/*
 *  ADP (Another Data Processor) www.adp.la
 *  Copyright (C) 2010 Katsuhisa Ohfuji <katsuhisa@ohfuji.name>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 */
#ifndef KZ_ARRAY
#define KZ_ARRAY
#define DEFAULT_ALLOC_SIZE	8
// vbgz[ˑ̒` 
#if _WIN32
#define  __attribute__(X) 
#else
#define __forceinline
#endif

// XJ[^pvectorNX
template < typename _T >
class Array {
	_T	*_data;
	size_t	_size;
	size_t	_capacity;
public:
	typedef	_T*	iterator;
	typedef	const _T*	const_iterator;

	void init() {_capacity = 0; _data = 0;_size = 0; }
	void init(const Array &src) {
		if ( src._data == 0 ) {
			_capacity = 0;
			_data = 0;
			_size = 0;
		} else {
			_capacity = src._size;
			_data = ((_T *)operator new(_capacity * sizeof(_T)));
			_size = src._size;
			memcpy( _data, src._data, sizeof(_T) * _size);
		}
	}
	Array() { init(); }
	Array( const Array &src ) { init(src); }
	Array( size_t size, _T val) {
		_capacity = _size = size;
		_data = ((_T *)operator new(_capacity * sizeof(_T)));
		for ( size_t i = 0; i < _size; i++ ) {
			_data[i] = val;
		}
	}
	Array( size_t size) {
		_capacity = size;
		_data = ((_T *)operator new(_capacity * sizeof(_T)));
		_size = 0;
	}
	void reserve( size_t capacity) {
		if ( capacity <= _capacity ) return;
		if ( _size > 0 ) {
			_T	*ndata = ((_T *)operator new(capacity * sizeof(_T)));
			memcpy( ndata, _data, sizeof(_T) * _size);
			if ( _data != 0 ) operator delete(_data);
			_data = ndata;
		} else {
			if ( _capacity > 0 ) operator delete(_data);
			_data = ((_T *)operator new(capacity * sizeof(_T)));
		}
		_capacity = capacity;
	}
	Array & operator =( const Array &src ) {
		if ( _capacity < src._size ) {
			_capacity = src._size;
			if ( _data != 0 ) operator delete(_data);
			_data = ((_T *)operator new(_capacity * sizeof(_T)));
		}
		_size = src._size;
		memcpy( _data, src._data, sizeof(_T) * _size);
		return *this;
	}
	void assign( size_t size, _T val) {
		if ( _capacity < size ) {
			_capacity = size;
			if ( _data != 0 ) operator delete(_data);
			_data = ((_T *)operator new(_capacity * sizeof(_T)));
		}
		_size = size;
		for ( size_t i = 0; i < _size; i++ ) {
			_data[i] = val;
		}
	}
	size_t	size() const { 
		return _size; 
	}
	bool empty() const { 
		return _size == 0; 
	}
	iterator begin() { 
		return _data; 
	}
	const_iterator begin() const { 
		return _data; 
	}
	iterator end()	{ 
		return _data + _size; 
	}
	const_iterator end() const { 
		return _data + _size; 
	}
	_T &front() const { 
		return *_data; 
	}
	__forceinline _T &back() const __attribute__((always_inline)) { 
		return _data[_size-1]; 
	}

	__forceinline _T &operator[](size_t idx) __attribute__((always_inline)) { 
		assert(idx < _size);
		return *(_data + idx);
	}

	__forceinline const _T operator[](size_t idx) const __attribute__((always_inline)) { 
		if ( idx >= _size ) {
			cout << "error!";
		}
		assert(idx < _size);
		return _data[idx]; 
	}

	void pop_back() {
		if ( _size > 0 ) {
			_size--;
		}
	}
	
	__forceinline void push_back() __attribute__((always_inline)) {
		if ( _capacity <= _size ) {
			_capacity *= 2;
			if ( _capacity <= 0 ) {
				_capacity = DEFAULT_ALLOC_SIZE;
			}
			_T	*ndata = ((_T *)operator new(_capacity * sizeof(_T)));
			memcpy( ndata, _data, sizeof(_T) * _size);
			if ( _data != 0 ) operator delete(_data);
			_data = ndata;
		}
		new (_data + _size) _T();
		_size++;
	}

	__forceinline void push_back( _T val ) __attribute__((always_inline)) {
		if ( _capacity <= _size ) {
			_capacity *= 2;
			if ( _capacity <= 0 ) {
				_capacity = DEFAULT_ALLOC_SIZE;
			}
			_T	*ndata = ((_T *)operator new(_capacity * sizeof(_T)));
			memcpy( ndata, _data, sizeof(_T) * _size);
			if ( _data != 0 ) operator delete(_data);
			_data = ndata;
		}
		new (_data + _size) _T(val);
		_size++;
	}
	iterator insert( iterator s, _T val ) {
		assert( _data <= s && s <= _data + _size );
		if ( _capacity <= _size ) {
			_capacity *= 2;
			if ( _capacity <= 0 ) {
				_capacity = DEFAULT_ALLOC_SIZE;
			}
			_T	*ndata = ((_T *)operator new(_capacity * sizeof(_T)));
			if ( _size > 0 ) memcpy( ndata, _data, sizeof(_T) * _size);
			if ( _data != 0 ) operator delete(_data);
			s = s - _data + ndata;
			_data = ndata;
		}
		if ( s < _data + _size ) {
			memmove( s + 1, s, sizeof(_T) * (_data + _size - s));
		}
		new (s) _T(val);
		_size++;
		return s;
	}
	iterator insert( iterator s, iterator begin, iterator end ) {
		assert( _data <= s && s <= _data + _size );
		size_t	siz = end - begin;
		if ( siz == 0 ) return s;
		if ( _capacity <= _size + siz ) {
			_capacity *= 2;
			if ( _capacity < _size + siz ) {
				_capacity = _size + siz;
			}
			_T	*ndata = ((_T *)operator new(_capacity * sizeof(_T)));
			if ( _size > 0 ) memcpy( ndata, _data, sizeof(_T) * _size);
			if ( _data != 0 ) operator delete(_data);
			s = s - _data + ndata;
			_data = ndata;
		}
		if ( s < _data + _size ) {
			memmove( s + siz, s, sizeof(_T) * (_data + _size - s));
		}
		memcpy( s, begin, sizeof(_T) * siz);
		_size += siz;
		return s;
	}
	iterator erase( iterator s ) {
		return erase( s, s+1);
	}
	iterator erase( iterator s, iterator e ) {
		for ( size_t i = 0; e + i < _data + _size; i++ ) {
			s[i] = e[i];
		}
		_size -= e - s;
		return s;
	}
	void clear() { 
		_size = 0; 
	}

	// fXgN^̑
	void deleteme() {
		if ( _data != 0 ) { 
			operator delete(_data);
			 _data = 0;
			_size = _capacity = 0;
		}
	}
	
	~Array() { deleteme(); }
};

#endif
