/*
 * Decompiled with CFR 0.152.
 */
package net.y3n20u.aeszip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import net.y3n20u.aeszip.AesCtrBlockCipherOutputStream;
import net.y3n20u.aeszip.AesZipEntry;
import net.y3n20u.aeszip.InvalidMethodException;
import net.y3n20u.aeszip.MacFilterOutputStream;

public class AesZipOutputStream
extends FilterOutputStream {
    private Deflater _deflater;
    private DeflaterOutputStream _deflaterOut;
    private AesCtrBlockCipherOutputStream _cipherOut;
    private MacFilterOutputStream _macFilter;
    private final List<AesZipEntry> _entryList;
    private AesZipEntry _currentEntry;
    private int _totalWrittenSize;
    private int _writtenSize;
    private String _comment;
    private OutputStream _targetStream;

    public AesZipOutputStream(OutputStream outputStream) {
        super(outputStream);
        this._macFilter = new MacFilterOutputStream(this.out);
        this._cipherOut = new AesCtrBlockCipherOutputStream(this._macFilter);
        this._totalWrittenSize = 0;
        this._entryList = new ArrayList<AesZipEntry>();
    }

    @Override
    public synchronized void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this._currentEntry == null) {
            throw new IllegalStateException("you should put an entry before writing data.");
        }
        this._targetStream.write(byArray, n, n2);
        this._writtenSize += n2;
    }

    public void setZipFileComment(String string) {
        if (string == null) {
            string = "";
        } else {
            try {
                if (string.getBytes("UTF-8").length > 65535) {
                    throw new IllegalArgumentException(MessageFormat.format("the comment is too long: {0}", string.getBytes("UTF-8").length));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        this._comment = string;
    }

    public void putNextZipEntry(AesZipEntry aesZipEntry) throws IOException {
        if (aesZipEntry == null) {
            throw new NullPointerException();
        }
        int n = aesZipEntry.getMethod();
        if (n != 99 && n != 0) {
            throw new InvalidMethodException(n);
        }
        if (this.hasSameNameEntry(aesZipEntry.getName())) {
            throw new IllegalArgumentException(MessageFormat.format("[{0}] already exists.", aesZipEntry.getName()));
        }
        if (this._currentEntry != null) {
            this.closeZipEntry();
        }
        this._currentEntry = aesZipEntry;
        this._currentEntry.setRelativeOffsetOfLocalFileHeader(this._totalWrittenSize);
        if (aesZipEntry.isDirectory()) {
            aesZipEntry.setMethod(0);
            this._currentEntry.setCompressedSize(0L);
            this._currentEntry.setSize(0L);
            this._currentEntry.setCrc(0L);
            this._entryList.add(this._currentEntry);
            this.writeLocalFileHeader(this._currentEntry);
            this._currentEntry = null;
        } else {
            this.writeLocalFileHeader(this._currentEntry);
            this.writeByteArray(this._currentEntry.getSaltValue());
            this.writeByteArray(this._currentEntry.getPasswordVerificationValue());
            this.initStream();
            this._writtenSize = 0;
        }
    }

    private void initStream() {
        this._macFilter.init(this._currentEntry.getAuthenticationKey());
        this._cipherOut.init(this._currentEntry.getEncryptionKey());
        short s = this._currentEntry.getActualCompressionMethod();
        switch (s) {
            case 8: {
                this._deflater = new Deflater(9, true);
                this._deflaterOut = new DeflaterOutputStream((OutputStream)this._cipherOut, this._deflater);
                this._targetStream = this._deflaterOut;
                break;
            }
            case 0: {
                this._targetStream = this._cipherOut;
                break;
            }
            default: {
                throw new InvalidMethodException(s);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this._currentEntry != null) {
            this.closeZipEntry();
        }
        int n = this._totalWrittenSize;
        for (AesZipEntry aesZipEntry : this._entryList) {
            this.writeCentralFileHeader(aesZipEntry);
        }
        int n2 = this._totalWrittenSize - n;
        this.writeEndOfCentralFileHeader(n2, n);
        super.close();
    }

    public void closeZipEntry() throws IOException {
        long l;
        if (this._currentEntry == null) {
            throw new IllegalStateException();
        }
        this._entryList.add(this._currentEntry);
        long l2 = this._writtenSize;
        short s = this._currentEntry.getActualCompressionMethod();
        switch (s) {
            case 8: {
                this._deflaterOut.finish();
                l = this._deflater.getBytesWritten();
                break;
            }
            case 0: {
                l = l2;
                break;
            }
            default: {
                throw new InvalidMethodException(s);
            }
        }
        this._totalWrittenSize = (int)((long)this._totalWrittenSize + l);
        this._cipherOut.flush();
        this._currentEntry.setCompressedSize(l);
        this._currentEntry.setSize(l2);
        this._currentEntry.setCrc(this._macFilter.getCrc());
        this.writeByteArray(this._macFilter.getAuthenticationCode());
        if ((AesZipOutputStream.generateFlagValue(this._currentEntry) & 8) == 8) {
            this.writeDataDescriptor(this._currentEntry);
        }
        this._currentEntry = null;
    }

    private void writeDataDescriptor(AesZipEntry aesZipEntry) throws IOException {
        this.writeLongInLittleEndian(134695760L, 4);
        this.writeLongInLittleEndian(0L, 4);
        this.writeLongInLittleEndian(aesZipEntry.getCompressedSize(), 4);
        this.writeLongInLittleEndian(aesZipEntry.getSize(), 4);
    }

    private void writeLocalFileHeader(AesZipEntry aesZipEntry) throws IOException {
        this.writeLongInLittleEndian(67324752L, 4);
        this.writeCommonFileHeader1(aesZipEntry);
        if ((AesZipOutputStream.generateFlagValue(this._currentEntry) & 8) == 8 || this._currentEntry.isDirectory()) {
            this.write4ByteFieldInLittleEndian(0);
            this.write4ByteFieldInLittleEndian(0);
            this.write4ByteFieldInLittleEndian(0);
        } else {
            this.write4ByteFieldInLittleEndian(0);
            this.write4ByteFieldInLittleEndian((int)aesZipEntry.getCompressedSize());
            this.write4ByteFieldInLittleEndian((int)aesZipEntry.getSize());
        }
        this.writeCommonFileHeader2(aesZipEntry);
        this.writeCommonFileHeader3(aesZipEntry);
    }

    private void writeCentralFileHeader(AesZipEntry aesZipEntry) throws IOException {
        this.writeLongInLittleEndian(33639248L, 4);
        this.write2ByteFieldInLittleEndian(this.getVersion(aesZipEntry));
        this.writeCommonFileHeader1(aesZipEntry);
        this.write4ByteFieldInLittleEndian(0);
        this.write4ByteFieldInLittleEndian((int)aesZipEntry.getCompressedSize());
        this.write4ByteFieldInLittleEndian((int)aesZipEntry.getSize());
        this.writeCommonFileHeader2(aesZipEntry);
        String string = aesZipEntry.getComment();
        int n = string == null ? 0 : string.getBytes("UTF-8").length;
        this.write2ByteFieldInLittleEndian((short)n);
        this.write2ByteFieldInLittleEndian((short)0);
        this.write2ByteFieldInLittleEndian((short)0);
        this.write4ByteFieldInLittleEndian(0);
        this.writeLongInLittleEndian(aesZipEntry.getRelativeOffsetOfLocalFileHeader(), 4);
        this.writeCommonFileHeader3(aesZipEntry);
        this.writeByteArray(string != null ? string.getBytes("UTF-8") : new byte[]{});
    }

    private void writeCommonFileHeader1(AesZipEntry aesZipEntry) throws IOException {
        this.write2ByteFieldInLittleEndian(this.getVersion(aesZipEntry));
        this.write2ByteFieldInLittleEndian(AesZipOutputStream.generateFlagValue(aesZipEntry));
        this.write2ByteFieldInLittleEndian((short)aesZipEntry.getMethod());
        this.write2ByteFieldInLittleEndian(aesZipEntry.getLastModTime());
        this.write2ByteFieldInLittleEndian(aesZipEntry.getLastModDate());
    }

    private void writeCommonFileHeader2(AesZipEntry aesZipEntry) throws IOException {
        byte[] byArray = aesZipEntry.getName().getBytes("MS932");
        if (byArray.length > 65535) {
            throw new IllegalArgumentException(MessageFormat.format("the name of this entry is too long: {0}", byArray.length));
        }
        this.write2ByteFieldInLittleEndian((short)byArray.length);
        byte[] byArray2 = aesZipEntry.getExtra();
        short s = (short)(byArray2 != null ? byArray2.length : 0);
        this.write2ByteFieldInLittleEndian(s);
    }

    private void writeCommonFileHeader3(AesZipEntry aesZipEntry) throws IOException {
        this.writeByteArray(aesZipEntry.getName().getBytes("MS932"));
        byte[] byArray = aesZipEntry.getExtra();
        if (byArray != null) {
            this.out.write(byArray);
            this._totalWrittenSize += byArray.length;
        }
    }

    private static short generateFlagValue(AesZipEntry aesZipEntry) {
        if (aesZipEntry == null) {
            throw new NullPointerException();
        }
        return aesZipEntry.isDirectory() ? (short)0 : 9;
    }

    private void writeEndOfCentralFileHeader(int n, int n2) throws IOException {
        this.writeLongInLittleEndian(101010256L, 4);
        this.write2ByteFieldInLittleEndian((short)0);
        this.write2ByteFieldInLittleEndian((short)0);
        this.write2ByteFieldInLittleEndian(this.getEntryListSize());
        this.write2ByteFieldInLittleEndian(this.getEntryListSize());
        this.write4ByteFieldInLittleEndian(n);
        this.write4ByteFieldInLittleEndian(n2);
        byte[] byArray = this._comment == null ? new byte[]{} : this._comment.getBytes("UTF-8");
        this.write2ByteFieldInLittleEndian((short)byArray.length);
        this.writeByteArray(byArray);
    }

    private short getEntryListSize() {
        int n = this._entryList.size();
        if (n > 65535 || n < 0) {
            throw new IllegalStateException(MessageFormat.format("the number of records too much: {0}", n));
        }
        return (short)n;
    }

    private boolean hasSameNameEntry(String string) {
        String string2 = string;
        if (!string.endsWith("/")) {
            string2 = string + "/";
        }
        for (AesZipEntry aesZipEntry : this._entryList) {
            if (!(aesZipEntry.getName().endsWith("/") ? string2.equalsIgnoreCase(aesZipEntry.getName()) : string2.equalsIgnoreCase(aesZipEntry.getName() + "/"))) continue;
            return true;
        }
        return false;
    }

    private short getVersion(AesZipEntry aesZipEntry) {
        short s = aesZipEntry.getActualCompressionMethod();
        switch (s) {
            case 8: {
                return 20;
            }
            case 0: {
                return 10;
            }
        }
        throw new InvalidMethodException(s);
    }

    private void writeByteArray(byte ... byArray) throws IOException {
        this.out.write(byArray);
        this._totalWrittenSize += byArray.length;
    }

    private void writeLongInLittleEndian(long l, int n) throws IOException {
        long l2 = l;
        for (int i = 0; i < n; ++i) {
            this.out.write((byte)(l2 & 0xFFL));
            l2 >>>= 8;
        }
        this._totalWrittenSize += n;
    }

    private void write2ByteFieldInLittleEndian(short s) throws IOException {
        this.out.write((byte)(s & 0xFF));
        this.out.write((byte)(s >>> 8 & 0xFF));
        this._totalWrittenSize += 2;
    }

    private void write4ByteFieldInLittleEndian(int n) throws IOException {
        this.out.write((byte)(n & 0xFF));
        this.out.write((byte)(n >>> 8 & 0xFF));
        this.out.write((byte)(n >>> 16 & 0xFF));
        this.out.write((byte)(n >>> 24 & 0xFF));
        this._totalWrittenSize += 4;
    }
}

