/*
 * Decompiled with CFR 0.152.
 */
package net.y3n20u.aeszip;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Date;
import net.y3n20u.aeszip.AesZipEntry;
import net.y3n20u.aeszip.AesZipOutputStream;

public class AesZipRecursiveEncrypter {
    public static int METHOD_DEFAULT = 8;
    private static final int BUFFER_SIZE = 16384;
    private File _destination;
    private URI _baseURI;
    private FileFilter _fileFilter;

    public AesZipRecursiveEncrypter() {
        this(null);
    }

    public AesZipRecursiveEncrypter(File file) {
        if (file == null) {
            this._destination = null;
        } else {
            if (file.isDirectory()) {
                throw new IllegalArgumentException();
            }
            this._destination = file;
        }
    }

    public void setFileFilter(FileFilter fileFilter) {
        this._fileFilter = fileFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archive(File file, String string) {
        if (this._destination == null) {
            this._destination = new File(file.getParent(), file.getName() + ".zip");
        }
        AesZipOutputStream aesZipOutputStream = null;
        try {
            aesZipOutputStream = new AesZipOutputStream(new FileOutputStream(this._destination));
            this._baseURI = file.getParentFile().toURI();
            this.archiveImpl(aesZipOutputStream, file, string.getBytes("UTF-8"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        finally {
            try {
                if (aesZipOutputStream != null) {
                    aesZipOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archiveImpl(AesZipOutputStream aesZipOutputStream, File file, byte[] byArray) {
        if (this._fileFilter != null && !this._fileFilter.accept(file)) {
            return;
        }
        String string = this._baseURI.relativize(file.toURI()).getPath();
        string = string + (file.isDirectory() && !string.endsWith("/") ? "/" : "");
        AesZipEntry aesZipEntry = new AesZipEntry(string, byArray);
        aesZipEntry.setActualCompressionMethod(METHOD_DEFAULT);
        aesZipEntry.setTime(new Date().getTime());
        try {
            aesZipOutputStream.putNextZipEntry(aesZipEntry);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.archiveImpl(aesZipOutputStream, file2, byArray);
            }
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray2 = new byte[16384];
            int n = inputStream.read(byArray2, 0, 16384);
            while (n != -1) {
                aesZipOutputStream.write(byArray2, 0, n);
                n = inputStream.read(byArray2, 0, 16384);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

