/*
 * Decompiled with CFR 0.152.
 */
package net.y3n20u.aeszip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.zip.CRC32;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class MacFilterOutputStream
extends FilterOutputStream {
    private Mac _authenticationMac;
    private CRC32 _crc;

    public MacFilterOutputStream(OutputStream outputStream) {
        super(outputStream);
        try {
            this._authenticationMac = Mac.getInstance("HmacSHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        this._crc = new CRC32();
    }

    public long getCrc() {
        return this._crc.getValue();
    }

    public byte[] getAuthenticationCode() {
        return Arrays.copyOf(this._authenticationMac.doFinal(), 10);
    }

    public void init(byte[] byArray) {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HmacSHA1");
        try {
            this._authenticationMac.init(secretKeySpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException);
        }
        this._crc.reset();
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this._crc.update(byArray, n, n2);
        this._authenticationMac.update(byArray, n, n2);
    }
}

