/*
 * Decompiled with CFR 0.152.
 */
package net.y3n20u.aeszip;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import net.y3n20u.aeszip.AesZipEntry;
import net.y3n20u.aeszip.AesZipOutputStream;
import net.y3n20u.aeszip.ArchiveProgressListener;
import net.y3n20u.aeszip.ArchiveProgressStatus;

public class AesZipEncrypter {
    protected static final String MESSAGE_INVALID_DESTINATION = "destination is invalid, maybe null or directory.";
    private static final int BUFFER_SIZE = 65536;
    public static int METHOD_DEFAULT = 8;
    private OutputStream destination;
    private boolean alreadyUsed;
    private Charset passwordCharset;
    private final HashMap<String, File> filesToBeArchived = new HashMap();
    private final HashMap<String, String> passwords = new HashMap();
    private ArchiveProgressListener progressListener;
    private ArchiveProgressStatus previousStatus;

    public AesZipEncrypter(OutputStream outputStream) {
        this.init(outputStream);
    }

    public AesZipEncrypter(File file) {
        FileOutputStream fileOutputStream;
        if (file == null || file.isDirectory()) {
            throw new IllegalArgumentException(MESSAGE_INVALID_DESTINATION);
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException(fileNotFoundException);
        }
        this.init(fileOutputStream);
    }

    protected void init(OutputStream outputStream) {
        this.ensureState();
        if (outputStream == null) {
            throw new IllegalArgumentException(new NullPointerException());
        }
        this.destination = outputStream;
        this.alreadyUsed = false;
        this.passwordCharset = Charset.defaultCharset();
    }

    public void setProgressListener(ArchiveProgressListener archiveProgressListener) {
        this.ensureState();
        this.progressListener = archiveProgressListener;
    }

    protected boolean isAlreadyUsed() {
        return this.alreadyUsed;
    }

    public void setPasswordCharset(Charset charset) {
        this.ensureState();
        if (charset == null) {
            throw new IllegalArgumentException(new NullPointerException());
        }
        this.passwordCharset = charset;
    }

    public Charset getPasswordCharset() {
        return this.passwordCharset;
    }

    public void add(String string, File file, String string2) {
        this.ensureState();
        this.filesToBeArchived.put(string, file);
        this.passwords.put(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archive() throws IOException {
        this.ensureState();
        this.alreadyUsed = true;
        AesZipOutputStream aesZipOutputStream = null;
        if (this.progressListener != null) {
            this.progressListener.start();
            this.generateProgressStatus();
        }
        try {
            aesZipOutputStream = new AesZipOutputStream(this.destination);
            for (String string : this.filesToBeArchived.keySet()) {
                File file = this.filesToBeArchived.get(string);
                byte[] byArray = this.passwords.get(string).getBytes(this.getPasswordCharset());
                this.archiveImplForEachFile(aesZipOutputStream, file, string, byArray);
            }
            if (this.progressListener != null) {
                this.progressListener.finishedAll();
            }
        }
        finally {
            try {
                if (aesZipOutputStream != null) {
                    aesZipOutputStream.close();
                }
            }
            finally {
                if (this.destination != null) {
                    this.destination.close();
                }
            }
        }
    }

    private void generateProgressStatus() {
        long l = 0L;
        for (File file : this.filesToBeArchived.values()) {
            l += file.length();
        }
        this.previousStatus = new ArchiveProgressStatus(this.filesToBeArchived.size(), 0, l, 0L, -1L, 0L);
    }

    private void archiveImplForEachFile(AesZipOutputStream aesZipOutputStream, File file, String string, byte[] byArray) throws IOException {
        boolean bl = file.isDirectory() && !string.endsWith("/");
        String string2 = string + (bl ? "/" : "");
        AesZipEntry aesZipEntry = new AesZipEntry(string2, byArray);
        aesZipEntry.setActualCompressionMethod(METHOD_DEFAULT);
        aesZipEntry.setTime(new Date().getTime());
        aesZipOutputStream.putNextZipEntry(aesZipEntry);
        long l = file.length();
        String string3 = file.getCanonicalPath();
        if (this.progressListener != null) {
            this.previousStatus = this.previousStatus.generateUpdatedStatusWithNextEntry(l, string3, string2);
            this.progressListener.notifyStatus(this.previousStatus);
        }
        if (file.isDirectory()) {
            return;
        }
        this.readAndWriteFileContents(file, aesZipOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndWriteFileContents(File file, AesZipOutputStream aesZipOutputStream) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = new byte[65536];
            int n = inputStream.read(byArray, 0, 65536);
            while (n != -1) {
                aesZipOutputStream.write(byArray, 0, n);
                if (this.progressListener != null) {
                    this.previousStatus = this.previousStatus.generateUpdatedStatus(n);
                    this.progressListener.notifyStatus(this.previousStatus);
                }
                n = inputStream.read(byArray, 0, 65536);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void ensureState() {
        if (this.isAlreadyUsed()) {
            throw new IllegalStateException("already started archiving.");
        }
    }
}

