#!/usr/bin/perl

use lib("./extlib/");  #WWW:Mixi
use WWW::Mixi;

use lib("../../extlib");  #general
use HTML::Template;
use CGI;
use Cwd;
use Jcode;
#
use lib("../../lib");  #Affelio
use AffelioApp;
use Affelio::misc::CGIError;
#
use lib("./extlib/");  #WWW:Mixi
use WWW::Mixi;
use HTTP::Cookies;
use HTTP::Request::Common;
#
use lib("./lib/"); 
use AffelioApp::SNSGateway;

###########################################################################
#init
###########################################################################
my $cgi = new CGI();

#AffelioAppを初期化
my $afap = new AffelioApp(ConfigDir => Cwd::getcwd(),
			  cgi => $cgi);

my $page = $cgi->url_param("page");

###########################################################################
#Output
###########################################################################
#Content-typeを出力
print "Content-type: text/html; charset=UTF-8\n";
print "Pragma: no-cache", "\n\n"; 

#HTML Header Partを出力
print $afap->get_HTML_header("Affelio Mixi Gateway");

# 読み込みアクセス権限をチェックし、内容表示
unless ($afap->check_access("DF_access")) {
    print "あなたにはこのページの読み込み権限がありません";
    
    #HTML Footer Partを出力
    print $afap->get_HTML_footer();

    exit(1);
}

###########################################################################
#Read configuration file
###########################################################################
my $userinfo = read_config($afap);

my $visitor_type = $afap->get_visitor_info("type");


###########################################################################
#Retrieve Mixi HTML
###########################################################################
my $err_mesg="";

if(($userinfo->{username} eq "") || ($userinfo->{password} eq "")){
    err_exit("Mixiユーザ情報が登録されていません。");
}

my $mixi = WWW::Mixi->new($userinfo->{username}, $userinfo->{password});
if($@){
    err_exit($@);
}

#Login
my $response = $mixi->login;
if(!($response->is_success)){
    err_exit("Could not login to Mixi!");
}

#Get HTML
my $url = 'list_friend.pl';
if($page){
    $url .= '?page=' . $page;
}

$response = $mixi->get($url);
if(!($response->is_success)){
    err_exit("Could not get list_friend.pl");
}
#print "<PRE>" . $response->content . "</PRE>";

#Parse
my @friends = $mixi->parse_list_friend( $response );

my $myid = $mixi->parse_self_id( $mixi->get("list_review.pl") );
my $my_home_url = "http://mixi.jp/show_friend.pl?id=" . $myid;
if($myid == 0){
    $my_home_url = "http://mixi.jp/";
}

###########################################################################
#Processing
###########################################################################
$num_friends = @friends;

for(my $i=0; $i < $num_friends; $i++){
    $friends[$i]->{subject} = 
	Jcode->new( $friends[$i]->{subject} )->utf8;

    if($visitor_type eq "self"){
	$friends[$i]->{visitor_type} = "self";
    }else{
	$friends[$i]->{visitor_type} = "";
    }
} 




my $next_message="";
my $next_link="";
my $next = $mixi->parse_list_friend_next( $response );
if($next){
    $next_message = Jcode->new( $next->{subject} )->utf8;
    $next->{link} =~ /(.*)page=([0-9]+)/;
    $next_link = "./index.cgi?page=$2";
}

my $prev_message="";
my $prev_link="";
my $prev = $mixi->parse_list_friend_previous( $response );
if($prev){
    $prev_message = Jcode->new( $prev->{subject} )->utf8;
    $prev->{link} =~ /(.*)page=([0-9]+)/;
    $prev_link = "./index.cgi?page=$2";
}


my $tmpl = HTML::Template->new(filename => "./templates/index.tmpl",
			       die_on_bad_params => 0);

$tmpl->param(install_title => $afap->get_app_info("install_title"));    
$tmpl->param(my_home_url => $my_home_url);
$tmpl->param(my_nickname => $afap->get_owner_info("nickname"));
$tmpl->param(friends => \@friends);
$tmpl->param(next_link => $next_link);
$tmpl->param(next_message => $next_message);
$tmpl->param(prev_link => $prev_link);
$tmpl->param(prev_message => $prev_message);

print $tmpl->output;

#HTML Footer Partを出力
print $afap->get_HTML_footer();

exit(1);


sub err_exit{
    my $err_mesg = shift;

    my $tmpl = HTML::Template->new(filename => "./templates/error.tmpl",
				   die_on_bad_params => 0);
    $tmpl->param(install_title => $afap->get_app_info("install_title"));    
    $tmpl->param(my_home_url => $my_home_url);
    $tmpl->param(err_mesg => $err_mesg);

    print $tmpl->output;

     #HTML Footer Partを出力
    print $afap->get_HTML_footer();
    exit(1);
}
