#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require './common/header.pl';
unless ($afap->get_visitor_info("type") eq "self"){
	&errorExit("あなたはこのページにアクセスする権限がありません")
        }


my $tmpl = HTML::Template->new(filename => "./templates/edit_album.tmpl");

my $id = $afap->{cgi}->param("id");

$tmpl->param(ID => $id);

# 編集完了
if($afap->{cgi}->param("edit")) {
	$album->updateEntry($id, $afap->{cgi}->param("title"), $afap->{cgi}->param("contents"));
	$tmpl->param(DONE => "1", DONE_LABEL => "内容を変更しました");
}

# 削除完了
elsif($afap->{cgi}->param("delete")) {
	$album->removeAlbum($id);
	$tmpl->param(DONE => "1", DONE_LABEL => "削除しました");
}

# 確認
elsif($afap->{cgi}->param("delete_confirm")) {
	$tmpl->param(DELETE_CONFIRM => "1");
}

# コメント編集画面
elsif ($afap->{cgi}->param("comment_edit")){
	$tmpl->param(EDIT => "1");
	my $entry = $album->getEntry($id);
	$entry->{contents} =~ s/<br \/>/\n/g;
	$tmpl->param(
		TITLE => $entry->{title}, 
		CONTENTS => $entry->{contents},
#		DATETIME => "$entry->{year}年$entry->{month}月$entry->{day}日",
	);
}

# 画像編集画面
elsif ($afap->{cgi}->param("image_arrange")){
	$tmpl->param(ARRANGE => "1");

# サムネイルの表示
my $col_num=4;
my @image_files;
my @image_row;
my @image_filelist=$album->getAllImage($id);
if ($#image_filelist>=0){
	$tmpl->param(HAS_IMAGE => 1);
        for (my $i=0; $i<($#image_filelist+1)%$col_num; $i++){
              	push @image_filelist, "";
        }

      	for (my $i=0; $i<($#image_filelist+1)/$col_num; $i++){
		$i_num=$i*$col_num;
      		for (my $j=0; $j<$col_num; $j++){
			push @image_files,
       			{
	                        IMAGE => $image_filelist[$i_num+$j]->{image},
      				ID2 => $id,
                      		PKEY=> $image_filelist[$i_num+$j]->{pkey}
       			};
      		}
		push @image_row,
              	{IMG => [@image_files[$i_num..($i_num+($col_num-1))]]};

       	}
	$tmpl->param(THUMBNAIL => \@image_row);
}

# コメント
if($album->getCommentsNo($id) > 0) {
	$tmpl->param(HAS_COMMENTS => 1);
	my @comments_param;
	my @comments = $album->getComments($id);
	foreach(@comments) {
		my ($sec, $min, $hour, $mday, $mon, $year) = localtime($_->{timestamp});
		$mon += 1;
		push @comments_param,
		{
			UNAME => $_->{user},
			COMMENT_TIME => "$mon月$mday日$hour:$min",
			COMMENT => $_->{comment},
                        PKEY=> $_->{pkey}
		};
	}
	$tmpl->param(COMMENTS => \@comments_param);
}


}
print $tmpl->output;

require './common/footer.pl';
