#!/usr/bin/perl
# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require 'init.pl';
$diary->checkAccess('write_diary');

my $id = $afap->{cgi}->param('id') or $diary->errorExit('記事番号が指定されていません');

$diary->errorExit("存在しない記事です") unless $diary->existsEntry($id);

my $tmpl;

# 編集完了
if($afap->{cgi}->param('edit')) {
	# send trackback ping
	if ($afap->{cgi}->param('tping_url')) {
		$diary->sendTrackbackPing($afap->{cgi}->param('tping_url'), $title, $contents, $id);
	}
	
	$diary->updateEntry($id, $afap->{cgi}->param('title'), $afap->{cgi}->param('contents'));
	
	my $filename_1 = $afap->{cgi}->param('filename_1');
	my $filename_2 = $afap->{cgi}->param('filename_2');

	if ($afap->{cgi}->param('delete_images') or $filename_1 or $filename_2) {
		$diary->removeUploadedImage($id);
	}
	if ($filename_1) {
		$diary->saveUploadedImage($filename_1, $id);
	}
	if ($filename_2) {
		$diary->saveUploadedImage($filename_2, $id);
	}

	print $diary->getRedirection("show_diary.cgi?id=$id");
	exit;
}

# 削除完了
elsif($afap->{cgi}->param('delete')) {
	$diary->removeEntry($id);
	print $diary->getRedirection("list_diary.cgi");
	exit;
}

# 確認
elsif($afap->{cgi}->param("delete_confirm")) {
	$tmpl = HTML::Template->new(filename => "./templates/edit_diary_delete_confirm.tmpl");
	my $entry = $diary->getEntry($id);
	$tmpl->param(ID => $entry->{id});
}

# 編集画面
else {
	$tmpl = HTML::Template->new(filename => "./templates/edit_diary_edit.tmpl");
	my $entry = $diary->getEntry($id);
	$entry->{contents} =~ s/<br[^>]*>/\n/g;
	$entry->{contents} =~ s/<\/?a[^>]*>//g;
	$tmpl->param(
		ID => $entry->{id},
		TITLE => $entry->{title}, 
		CONTENTS => $entry->{contents},
		DATETIME => "$entry->{year}年$entry->{month}月$entry->{day}日",
	);
}

print $diary->get_HTML_header;
print $tmpl->output;
print $diary->get_HTML_footer;
