#!/usr/bin/perl
# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require 'init.pl';

my $id = $afap->{cgi}->param('id') or die;
my $filename = $afap->{cgi}->param('filename') or die;

my $type = $filename;
$type =~ s/[^.]+\.(.*)/$1/i;
$type =~ s/jpg/jpeg/i;
my $filepath = "$diary->{datadir}img/$id/".$filename;

my $width  = $afap->{cgi}->param('w');
my $height = $afap->{cgi}->param('h');

binmode STDOUT;
print "Content-type: image/$type\n\n";
if ($width and $height and (eval 'use Image::Magick; 1;')) {
	my $image = new Image::Magick;
	$image->Read(filename => $filepath);
	my ($w, $h) = $image->Get('columns', 'rows');
	if ($w > $width or $h > $height) {
		$image->Resize(geometry => $width.'x'.$height);
		$image->Set(quality => 75);
	}
	$image->Write(file => \*STDOUT);
}
else {
	open(IMG, "$filepath") or die;
	binmode IMG;
	print while (<IMG>);
	close(IMG);
}
