#!/usr/bin/perl
# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require 'init.pl';
$diary->checkAccess('write_comment');

my $id = $afap->{cgi}->param('id') or $diary->errorExit('記事番号が指定されていません');

$diary->errorExit("存在しない記事です") unless $diary->existsEntry($id);

my $user = $afap->get_visitor_info("nickname");

# コメント確認画面
if($afap->{cgi}->param('comment_confirm')) {
	my $tmpl = HTML::Template->new(filename => "./templates/write_comment_confirm.tmpl");
	$tmpl->param(COMMENT_SHOW => $diary->escape($afap->{cgi}->param('comment')), COMMENT => $afap->{cgi}->param('comment'), ID => $id);
	$tmpl->param(REQUIRE_NAME => 1) unless ($user);
	print $diary->get_HTML_header;
	print $tmpl->output;
	print $diary->get_HTML_footer;
}

# コメントをコミット
elsif($afap->{cgi}->param('comment_commit')) {

	if(!$user){
		$user = $afap->{cgi}->param('visitor_name');
	}else{
		$url = $afap->get_visitor_info('afid');
		if ($url =~ /<a href="([^"]*)"/) {
			$url = $1;
		}
		$url = $afap->get_site_info('web_root').'/outgoing.cgi?dest_url='.$url;
		$user = "<a href=\"$url\">".$afap->get_visitor_info("nickname")."</a>";
	}

    $diary->addComment($id, $user, $afap->{cgi}->param('comment'));

    print $diary->getRedirection("show_diary.cgi?id=$id");
    exit;
}

else {
	$diary->errorExit('不正なアクセスです');
}
