# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: GroupMemberTable.pm,v 1.3 2005/07/01 02:00:07 slash5234 Exp $

package Affelio::App::Admin::GroupMemberTable;
{
    use strict;

    use lib("../../../../extlib/");
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::MyCrypt qw( msg_encrypt url_encode);

    use Exporter;
    @Affelio::App::Admin::GroupMemberTable::ISA = "Exporter";
    @Affelio::App::Admin::GroupMemberTable::EXPORT = qw (show_GroupMember_table save_GroupMember_table);


    #####################################################################
    #save_GroupMember_table
    #####################################################################
    sub save_GroupMember_table{
	my $af = shift;                 #arg(1) AF
	my $q = shift;                  #arg(2) CGI
	my @params = $q->param;

	my @gid_array =();
	my @gid_uid_table =();

        foreach my $key (@params){
	    my $value = $q->param($key);
	    if($key =~ /^GRPHEADER__([0-9]*)/){
		my $this_gid =$1;
		push(@gid_array, $this_gid);
	    }
	    elsif($key =~ /^GRP__([0-9]*)__([0-9]*)/){
		my $this_gid =$1;
		my $this_uid =$2;

		push(@{$gid_uid_table[$this_gid]}, $this_uid);
	    }
	}

	foreach my $gid (@gid_array){
	    $af->{gm}->set_member_by_intarray($gid, \@{$gid_uid_table[$gid]});
	}

    }

    #####################################################################
    #show_GroupMember_table
    #####################################################################
    sub show_GroupMember_table{
	my $af = shift;                 #arg(1) AF
	my $output_ref = shift;         #arg(3) ref of %output_data; 
	
	debug_print("show_GroupMember_table:  start.");

	#######################################################
	#Row(1): Group names
	my @group_names=();
	$output_ref->{'group_names'} = \@group_names;

	my $groups_SQL = $af->{gm}->get_all_group_list();
	while( (my ($gid, $group_name, $members, $option_pid, $lastupdated, $f2list) =  $groups_SQL->fetchrow_array)){
	    
	    push(@group_names, 
		 {'group_name' => $group_name,
		  'gid' => "GRPHEADER__" . $gid }
		 );
	}

	my $group_num = @group_names;

	#######################################################
	#Read all friends and fill all the checkbox names
	my @members=();
	$output_ref->{'members'} = \@members;

	my $SQL_result = $af->{fm}->get_all_friend_list();
	my @person=();
	while(@person = $SQL_result->fetchrow_array) {
	    #For each friend....
	    debug_print("FriendRoutines: friend=(@person)");
	    #$person[0] uid
	    #$person[2] nickname

	    #Set my belonging groups
	    my @my_belonging_groups=();
	    for(my $i=1; $i<=$group_num; $i++){
		push(@my_belonging_groups,
		     ({'checkbox_name' => "GRP__$i".'__'. $person[0],
		       'checked_flag' =>  ""}
		      )
		     );
	    }

	    #Set "checked_flag" for each belonging group
	    my $SQL_result2 = $af->{gm}->get_groups_by_uid($person[0]);
	    while((my $tmp_gid, my @rest) = $SQL_result2->fetchrow_array) {
		$my_belonging_groups[$tmp_gid-1]{'checked_flag'} ="checked";
	    }

	    #Set my info into "members"
	    push(@members, 
		 ({'member_name' => $person[2],
		   'groups' => \@my_belonging_groups})
		 );
	}
    }




}#package
1;
