# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: Messaging.pm,v 1.15 2005/07/02 22:46:13 slash5234 Exp $

package Affelio::App::Admin::Messaging;
{
    use strict;

    use lib("../../../../extlib/");
    use Error qw(:try);
    use MIME::Base64::Perl;
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::Encoding qw(db_encode db_decode);
    use Affelio::misc::Time qw(timestamp2string get_timestamp);
    use Affelio::misc::WebInput;
    use Affelio::SNS::Handshaker_c;
    use Affelio::exception::CommunicationException;

    use Exporter;
    @Affelio::App::Admin::Messaging::ISA = "Exporter";
    @Affelio::App::Admin::Messaging::EXPORT = qw (show_message_list show_message mark_as_read get_new compose send_message);

    #######################################################################
    #send_message
    #######################################################################    
    sub send_message{
	my $af = shift;
	my $cgi = shift;

	debug_print("Mesg::send: start.");

	my $msg_to = $cgi->param("msg_to");
	my $msg_title = $cgi->param("msg_title");
	my $msg_body = $cgi->param("msg_body");

	debug_print("Mesg::send: $msg_to $msg_title $msg_body");

	my $passAB = $af->{fm}->get_attribute_by_afid($msg_to, "password");
	if(!defined($passAB) || $passAB eq ""){
	    #Exception!
	    exit(1);
	}
	debug_print("Mesg::send: passAB=[$passAB]");

	my $ret="";
	try{
	    $ret = post_Message(dest_uri =>  "$msg_to/bin/xml-rpc-serv.cgi",
				src => $af->{site__web_root},
				password => $passAB,
				msg_from => $af->{site__web_root},
				msg_from_nickname => $af->{user__nickname},
				msg_to => $msg_to,
				msg_timestamp => get_timestamp(),
				msg_title => $msg_title,
				msg_body => $msg_body);
	}catch Affelio::exception::NetworkException with{
	    my $E = shift;
	    throw Affelio::exception::CommunicationException($E);

	}catch Affelio::exception::InvalidInputException with{
	    my $E = shift;
	    error($cgi, "<PRE>Exception: " . $E .  "</PRE>");
	};
    }


    #######################################################################
    #compose
    #######################################################################    
    sub compose{
	my $af = shift;
	my $cgi = shift;
	my $output_ref = shift;
    	my $wi = new Affelio::misc::WebInput;

	my $reply_to = $cgi->param("reply_to");
	my $reply_title = $cgi->param("reply_title");
	my $reply_body = $cgi->param("reply_body");

	debug_print("Messaging::compose: start.");
	debug_print("Messaging::compose: Reply-To: [$reply_to]");

	############################
	#To:
	############################
	my @friends_list=();
	my $result = $af->{fm}->get_all_friend_list();
	while( my @row = $result->fetchrow_array ){

	    my $selected = "";
	    if($row[1] eq $reply_to){
		$selected ="selected";
	    } 
	    
	    push(@friends_list, {nickname => $row[2],
				 afid     => $row[1],
				 selected => $selected});
	    debug_print("Messaging::\t$row[2]");
	}
	$output_ref->{"friends"} = \@friends_list;

	############################
	#Title:
	############################
	$output_ref->{"msg_title"} = $reply_title;

	############################
	#Body:
	############################
	$output_ref->{"msg_body"} = $reply_body;


	debug_print("Messaging::compose: end.");
    }

    #######################################################################
    #mark_as_read
    #######################################################################    
    sub mark_as_read{
	my $wi = new Affelio::misc::WebInput;

	my $af = shift;
	my $mid = shift;
	$mid = $wi->PTN_num($mid);

	debug_print("marK_as_read: start");

	my $ret= $af->{mesgm}->mark_as_read($mid);

	debug_print("marK_as_read: end");
    }

    #######################################################################
    #get_new
    #######################################################################    
    sub get_new{
	my $af = shift;
	debug_print("get_new: start");

	my $ret= $af->{mesgm}->get_unread_message_num();

	debug_print("get_new: end");
	return($ret);
    }


    #######################################################################
    #show_message
    #######################################################################    
    sub show_message{
	my $wi = new Affelio::misc::WebInput;

	my $af = shift;
	my $mid = shift;
	$mid = $wi->PTN_num($mid);
	my $output_ref = shift;

	debug_print("show_message: start.");

	my @message= $af->{mesgm}->retrieve_message($mid);
	my ($msg_mid, $msg_timestamp, $msg_title, $msg_type,
	    $msg_from, $msg_body, $msg_readflag) = @message;

	if($msg_type=~ /Encode\-Base64/){
	    $msg_body = decode_base64($msg_body);
	}
	debug_print("show_message: $msg_from $msg_title $msg_type $msg_body");

	$msg_timestamp = timestamp2string($msg_timestamp);

	if($msg_type=~ /UserToUser/){
	    my $reply_title = "Re: $msg_title";
	    my $reply_body = $msg_body;
	    $reply_body =~ s/\r\n/\n/g;
	    $reply_body =~ s/\r/\n/g;
	    $reply_body =~ s/\n/\n>>/g;
	    $reply_body = "\r\n>>" . $reply_body;

	    my $reply_to="";
	    if($msg_from =~ /HREF="(.+)">/){
		$reply_to = $1;
	    }

	    my $reply_HTML = <<EOT;
<FORM METHOD="POST" ACTION="admin.cgi?mode=messages&action=compose">
<INPUT TYPE="hidden" NAME="reply_to" VALUE="$reply_to">
<INPUT TYPE="hidden" NAME="reply_title" VALUE="$reply_title">
<INPUT TYPE="hidden" NAME="reply_body" VALUE="$reply_body">
<INPUT TYPE="submit" VALUE="<AF_M text="Reply">">
</FORM>
EOT
            $$output_ref{"reply_HTML"} = $reply_HTML;

       }

	#URL ---> <A HREF="URL">URL</A>
	$msg_body = $wi->translate_URL_to_HTML($msg_body);
	#\n ----> <BR>
	$msg_body =~ s/\r\n/\n/g;
	$msg_body =~ s/\r/\n/g;
	$msg_body =~ s/\n/<BR>/g;

	###############
	#UserToUser (inter-Affelio massaging
	###############
	#XXX
	# This part is quite nasty. Since $msg_from is using format
	# like '<A HREF="url">nickname</A>' due to a weird DB problem,
	# We have to change the URL to the one through outgoing.cgi
	# by using ad-hoc regexes....
	if($msg_type =~ /UserToUser/){
	    $msg_from =~ /<A HREF="(.*)">(.+)<\/A>/;
	    debug_print("show_message_list: \t[$1]");
	    debug_print("show_message_list: \t[$2]");
	    
	    $msg_from = '<A HREF="' . $af->{site__web_root} . '/outgoing.cgi?dest_url=' . $1 . '" target="_blank">' . $2 . '</A>';
	}
	###########


	$$output_ref{"msg_timestamp"} = $msg_timestamp;
	$$output_ref{"msg_title"} = $msg_title;
	$$output_ref{"msg_from"} = $msg_from;
	$$output_ref{"msg_body"} = $msg_body;

	$$output_ref{"url2list"} = "$af->{site__web_root}/admin.cgi?mode=messages";

	debug_print("show_message: end.");
    }

    #######################################################################
    #show_message_list
    #######################################################################    
    sub show_message_list{
	my $af = shift;
	my $output_ref = shift;

	debug_print("show_message_list: start.");

	my @ret_messages=();
	$output_ref->{'messages'} = \@ret_messages;

	my $messages= $af->{mesgm}->retrieve_all_messages();

	my @message=();
	while(@message = $messages->fetchrow_array) {
	    my ($msg_mid, $msg_timestamp, $msg_title, $msg_type,
		$msg_from, $msg_body, $msg_readflag) = @message;

	    $msg_timestamp = timestamp2string($msg_timestamp);

	    debug_print("show_message_list: [$msg_title]");
	    debug_print("show_message_list: [$msg_from]");
	    debug_print("show_message_list: [$msg_body]");
	    debug_print("show_message_list: [$msg_timestamp]");

	    ###############
	    #UserToUser (inter-Affelio massaging
	    ###############
	    #XXX
	    # This part is quite nasty. Since $msg_from is using format
	    # like '<A HREF="url">nickname</A>' due to a weird DB problem,
	    # We have to change the URL to the one through outgoing.cgi
	    # by using ad-hoc regexes....
	    if($msg_type =~ /UserToUser/){
		$msg_from =~ /<A HREF="(.*)">(.+)<\/A>/;
		debug_print("show_message_list: \t[$1]");
		debug_print("show_message_list: \t[$2]");

		$msg_from = '<A HREF="' . $af->{site__web_root} . '/outgoing.cgi?dest_url=' . $1 . '" target="_blank">' . $2 . '</A>';
	    }
	    ###########


	    my $linkurl = "$af->{site__web_root}/admin.cgi?mode=messages&action=show&mid=$msg_mid";
	    push(@ret_messages, 
		 {
		     'msg_title' => $msg_title,
		     'msg_from' => $msg_from,
		     'msg_timestamp' => $msg_timestamp,
		     'readflag' => $msg_readflag,
		     'msg_linkurl' => $linkurl      
		     }
		 );
	}
	debug_print("show_message_list: end.");
    }


}
1;
