# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: ApplicationManager.pm,v 1.7 2005/07/01 02:00:08 slash5234 Exp $

package Affelio::Managing::ApplicationManager;
{
    use strict;
    use lib("../../../extlib");    
    use DBI;
    use Jcode;
    use lib("../../");
    use Affelio::misc::CGIError;
    use Affelio::misc::Encoding qw(db_encode db_decode);
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::exception::DBException;

    #######################################################################
    #Constructor
    #######################################################################
    sub new{
	my $class = shift;
	my $af = shift;
	my %apps=();

	debug_print("ApplicationManager::new: start.");
	my $self = {af => $af,
		    apps => %apps
		    };

	bless $self, $class;

	load_applications($self);

	debug_print("ApplicationManager::new: end.");
	return $self;
    }

    #####################################################################
    #get_summed_app_perm
    #####################################################################
    sub get_summed_app_perm{
	my $self = shift;               
	my $af = $self->{af};
	my $visitor_id = shift;         #arg(1) visitor_ID  
	my $visitor_mode = shift;       #arg(2) visitor_mode
	my $app_name =shift;            #arg(3) application install_name
	my $action_type =shift;         #arg(4) action_type

	my @ret_list=();

	debug_print("AppManager::get_summed_app_perm: start.");
	debug_print("AppManager::get_summed_app_perm: visitor_id  = $visitor_id");
	debug_print("AppManager::get_summed_app_perm: visitor_mode= $visitor_mode");
	debug_print("AppManager::get_summed_app_perm: app_name    = $app_name");
	debug_print("AppManager::get_summed_app_perm: action_type = $action_type");

	if($visitor_mode eq "f2" || $visitor_mode eq "pb"){
	    ####################
	    # f2 or PB
	    ####################

	    my $query = "select $action_type from AFuser_" . $app_name 
		."_permission where type = 'f' and target_id = '$visitor_mode'";

	    debug_print("AppManager::get_summed_app_perm: q=[$query]");
	    
	    my $sth = $af->{db}->prepare($query) or 
		throw Affelio::exception::DBException("cannot insert");
	    $sth->execute() or 
		throw Affelio::exception::DBException("cannot insert");

	    my @row = $sth->fetchrow_array;

	    debug_print("AppManager::get_summed_app_perm: end [$row[0]]");
	    return($row[0]);

	}elsif($visitor_mode eq "self"){

	    return(1);

	}else{
	    ####################
	    # f1
	    ####################
	    #We will make 
	    #  perm(f1) OR Vx(perm(G))

	    #################
	    #(1) as a friend
	    my $query = "select $action_type from AFuser_" . $app_name 
		."_permission where type = 'f' and target_id = '$visitor_mode'";
	    my $sth = $af->{db}->prepare($query) or 
		throw Affelio::exception::DBException("cannot insert");
	    $sth->execute() or 
		throw Affelio::exception::DBException("cannot insert");
	    my @row = $sth->fetchrow_array;
	    if($row[0] == 1){
		return(1);
	    }

	    #################
	    #(2) as a member of each group

	    #Get the visitor's UID
	    my ($t_uid, $t_afid, $t_nickname, $t_time,
		$t_pass, $t_intro, $t_pid, $t_lastupdated, $t_f2list) 
		= $af->{fm}->get_friend_by_afid($visitor_id);

	    #Get the visitor's groups
	    my $SQL_result = $af->{gm}->get_groups_by_uid($t_uid);

	    #For each group...
	    my @g_data=();
	    my $flag=0;
	    while(@g_data = $SQL_result->fetchrow_array) {	    
		my $gid = $g_data[0];

		my $query = "select $action_type from AFuser_" . $app_name 
		    ."_permission where type = 'g' and target_id = '$gid'";
		my $sth = $af->{db}->prepare($query) or 
		    throw Affelio::exception::DBException("cannot insert");
		$sth->execute() or 
		    throw Affelio::exception::DBException("cannot insert");
		my @row = $sth->fetchrow_array;

		if($row[0] ==1){
		    $flag=1;
		}
	    }

	    return($flag);

	}

    }

    ######################################################################
    #get_all_permission
    ######################################################################
    sub get_all_permission{
	my $self = shift;
	my $app_name = shift;          #arg(1) app install_name

	debug_print("get_all_premission: start");
	my $af = $self->{af};

	##############################
	#retrieve all permission records from DB
	my $query = 'SELECT * FROM AFuser_' . $app_name . '_permission';
	my $sth;
	eval{
	    $sth = $af->{db}->prepare($query);
	    $sth->execute;
	};
	if($@){
	    throw Affelio::exception::DBException($af->{db}->errstr);
	}

	debug_print("get_all_premission: end");
	return($sth);
    }

    ######################################################################
    #prepare_app_perm_table     Check Appliation Permission Table 
    ######################################################################
    sub prepare_app_perm_table{
	my $self = shift;
	my $af = $self->{af};
	my $caller = shift;   #application install name

	#Does my application's permission table already exist?
	my $my_table_name = "AFuser_" . $caller . "_permission"; 
	debug_print("AppManager::check_table: table = [".$my_table_name."]");

	my $query = "SELECT * FROM " . $my_table_name;
	eval{
	    my $sth = $af->{db}->prepare($query);
	    my @dummy = $sth->execute();
	};
	if($@){
	    #############################################
	    #Table of this application does not exist!
	    #Thus, we will make the table
	    my $create_table_SQL="CREATE TABLE $my_table_name (pid INTEGER, type TEXT, target_id  TEXT, DF_visibility INTEGER, DF_access INTEGER, ";
	    my $new_rec_SQL="insert into $my_table_name(pid, type, target_id, DF_visibility, DF_access, ";

	    my $num_action_types 
		= @{ $self->{apps}->{$caller}->{action_types} };
	    my $i;
	    for($i=0; $i < $num_action_types; $i++){
		$create_table_SQL .= 
		    ${ $self->{apps}->{$caller}->{action_types} }[$i];
		$create_table_SQL .= " INTEGER,"; 

		$new_rec_SQL .= 
		    ${ $self->{apps}->{$caller}->{action_types} }[$i];
		$new_rec_SQL .= ","; 

	    } 
	    chop($create_table_SQL);   #Delete "," at the end.
	    $create_table_SQL .= ") ";
	    chop($new_rec_SQL);   #Delete "," at the end.
	    $new_rec_SQL .= ")";

	    debug_print("AppManager::check_table: create_SQL = [".$create_table_SQL."]");

	    my $sth = $af->{db}->prepare($create_table_SQL) or 
		throw Affelio::exception::DBException("cannot create table");
	    $sth->execute() or 
		throw Affelio::exception::DBException("cannot create table");

	    debug_print("AppManager::check_table: created the table!");

	    #############################################
	    #Synchronized the table
	    # Find all records from AFuser_CORE_permission and
	    # prepare 0-filled records into my table
	    my $CORE_perm_tbl = $af->{perm}->get_all_permission();
	    while( my($pid, $type, $target, $dummy) = $CORE_perm_tbl->fetchrow_array ){

		my $SQL = $new_rec_SQL . " values ('$pid','$type','$target',1,0,";
		for($i=0; $i < $num_action_types; $i++){
		    $SQL .= "0,";
		}
		chop($SQL);
		$SQL .= ")";
		
		debug_print("AppManager::check_table: insert_SQL = [".$SQL."]");
		my $sth = $af->{db}->prepare($SQL) or 
		    throw Affelio::exception::DBException("cannot insert");
		$sth->execute() or 
		    throw Affelio::exception::DBException("cannot insert");

	    }


	}
	debug_print("AppManager::check_table: end.");
    }

    ######################################################################
    #update_permission
    ######################################################################
    sub update_permission{
	my $self = shift;
	my $af = $self->{af};

	my $app_name = shift;
	my $pid = shift;
	my $action_type = shift;
	my $value = shift;

	#prepare SQL query
	my $query = "update AFuser_" . $app_name . "_permission set "
	    . "$action_type = $value where pid=$pid";
	#debug_print("AppManager::update_permission q=[$query]");

	#access DB
	my $sth;
	eval{
	    $sth = $af->{db}->prepare($query);
	    $sth->execute;
	};
	if($@){
	    throw Affelio::exception::DBException($af->{db}->errstr);
	}

	#debug_print("AppManager::update_permission end.");
    }


    ######################################################################
    #load_applications
    ######################################################################
    sub load_applications{
	my $self = shift;
	my $af = $self->{af};

	my $app_dir;
	opendir(DIR, "$af->{cfg_dir}/apps");
	while (defined($app_dir = readdir(DIR))) {
	    if( ($app_dir ne '.') 
		&& ($app_dir ne '..') 
		&& ($app_dir ne 'index.html') 
		&& ($app_dir ne 'sampleapp') 
		&& ($app_dir ne 'CVS')
		){

		##################################
		#For each found application...
		##################################
		debug_print("Affelio::load_apps: [$app_dir]");

		##################################
		#Open a config file
		##################################
		my $cfg = new Config::IniFiles( -file => "$af->{cfg_dir}/apps/$app_dir/AF_app.cfg" );
		if(!$cfg){ next; }

		my %this_app=();
		my $err_flag=0;
		##################################
		#Read application-specific parameters
		##################################
		my @read_parameter_list=
		    ("app_name", "app_version", "app_author",
		     "guest_index", "owner_index", 
		     "action_types", "action_types_desc");
		
		foreach my $param (@read_parameter_list){
		    my $data = $cfg->val('application', $param);
		    if ($data){
			debug_print("Affelio::load_apps: \t$param = $data");
			$this_app{$param} = $data;
		    }else{
			debug_print("Affelio::load_apps: \t$param not found.");
			$err_flag=1;
		    }
		}

		my @this_app_action_types =();
		my @this_app_action_types_desc =();
		@this_app_action_types =split(',\s', $this_app{action_types});
		@this_app_action_types_desc =split(',', $this_app{action_types_desc});

		##################################
		#Read installation-specific parameters
		##################################
		my @inst_parameter_list= ("title");

		foreach my $param (@inst_parameter_list){
		    my $data = $cfg->val('this_installation', $param);
		    if ($data){
			debug_print("Affelio::load_apps: \t$param = $data");
			$this_app{"install_" . $param} = $data;
		    }else{
			debug_print("Affelio::load_apps: \t$param not found.");
			$err_flag=1;
		    }
		}

		##################################
		#Store into Affelio's hash
		##################################
		if(!$err_flag){
		    $self->{apps}->{$app_dir}
		    = {'app_name' => $this_app{'app_name'},
		       'app_version' => $this_app{'app_version'},
		       'app_author' => $this_app{'app_author'},
		       'guest_index' => $this_app{'guest_index'},
		       'owner_index' => $this_app{'owner_index'},
		       #
		       'action_types' => \@this_app_action_types,
		       'action_types_desc' => \@this_app_action_types_desc,
		       #
		       'install_name' => $app_dir,
		       'install_title' => $this_app{'install_title'}
		       };
		}
	    
	    }#if
	}#while	

    }






}
1;
