# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: PermissionManager.pm,v 1.4 2005/07/01 02:00:08 slash5234 Exp $

package Affelio::Managing::PermissionManager;
{
    use strict;

    use lib("../../../extlib");    
    use DBI;
    use lib("../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::exception::DBException;

    ########################################################################
    #Constructor
    ########################################################################
    sub new{
	my $class = shift;
	my $af = shift;

	debug_print("PermissionManager::new: start.");

	my $self = {af => $af
		    };

	bless $self, $class;

	debug_print("PermissionManager::new: end.");
	return $self;
    }

    ########################################################################
    #(1)add_permission
    ########################################################################
    sub add_permission{         #return int pid
	my $self = shift;
	my $type = shift;       #arg(1) IN char* type
	my $id = shift;         #arg(2) IN char* target_id
	my $flag_array_ref = shift; #arg(3) IN * flag_array_ref

	my @flag_array = @$flag_array_ref;
	my $flag_size = @flag_array;

	debug_print("add_permission type[$type] id[$id] size(flag)=$flag_size");
	my $af = $self->{af};

	#add more elements upto 63
	for(my $i=$flag_size; $i<=63; $i++){
	    push(@flag_array, "-1");
	}
	$flag_size = @flag_array;

	debug_print("add_permission (increased) size(flag)=$flag_size");

	#Decide $newid
	my $query = 'SELECT max(pid) FROM AFuser_CORE_permission';
	my $sth;
	eval{
	    $sth= $af->{db}->prepare($query);
	    $sth->execute;
	};
	if($@){
	    throw Affelio::exception::DBException($af->{db}->errstr);
	}

	my @row = $sth->fetchrow_array;
	my $maxid = $row[0];
	if(defined($row[0])){
	    $maxid = $row[0];
	}else{
	    $maxid = 0;
	}
	my $newid = $maxid + 1;

	#generate an SQL query
	$query = "insert into AFuser_CORE_permission(pid, type, target_id";
	for(my $j=0; $j<=63; $j++){
	    $query .= ", attr$j";
	}
	$query .=  ") values (?,?,?";
	for(my $k=0; $k<=63; $k++){
	    $query .= "," . $flag_array[$k];
	}
	$query .= ")";
	debug_print("add_permission q=[$query]");

	#DB access
	eval{
	    $sth = $af->{db}->prepare($query);
	    $sth->execute($newid, $type, $id);
	};
	if($@){
	    throw Affelio::exception::DBException($af->{db}->errstr);
	}

	debug_print("add_permission DB access done.");

	#Set new_id into Friend table or Group table
	if($type eq "f"){
	}
	if($type eq "p"){
	    #Set this new pid into Friend table record.
	    try{
		$af->{fm}->set_attribute_by_id($id, "option_pid", $newid); 
	    }catch Affelio::exception::DBException with {
		my $e = shift; 
		throw $e;
	    };
	}
	if($type eq "g"){
	    #Set this new pid into Group table record.
	    $af->{gm}->set_pid($id, $newid);
	}

	debug_print("add_permission end.");
	return($newid);
    }


    ########################################################################
    #(2)update_permission
    ########################################################################
    sub update_permission{             #void
	my $self = shift;
	my $pid = shift;            #arg(1) IN int pid
	my $flag_array_ref = shift; #arg(2) IN * flag_array_ref

	my @flag_array = @$flag_array_ref;

	debug_print("update_permission pid[$pid]");
	my $af = $self->{af};

	#add more elements upto 63
	my $flag_size = @flag_array;
	for(my $i=$flag_size; $i<=63; $i++){
	    push(@flag_array, "-1");
	}

	#prepare SQL query
	my $query = "update AFuser_CORE_permission set ";
	for(my $k=0; $k<=63; $k++){
	    $query .= " attr$k = '" .  $flag_array[$k] . "'," ;
	}
	chop($query);
	$query .= " where pid='$pid'";
	debug_print("update_permission q=[$query]");

	#access DB
	my $sth;
	eval{
	    $sth = $af->{db}->prepare($query);
	    $sth->execute;
	};
	if($@){
	    throw Affelio::exception::DBException($af->{db}->errstr);
	}

	debug_print("PermissionManager::update_permission end.");
    }

    ########################################################################
    #(3)get_permission
    ########################################################################
    sub get_permission{         #return SQL_result
	my $self = shift;
	my $type = shift;       #arg(1) IN char* type
	my $id = shift;         #arg(2) IN char* target_id

	debug_print("get_permission type[$type] id[$id]");
	my $af = $self->{af};

	my $query = "SELECT * FROM AFuser_CORE_permission where type='$type' and target_id='$id'";
	debug_print("get_permission end: q=[$query]");

	my $sth;
	eval{
	    $sth = $af->{db}->prepare($query);
	    $sth->execute;
	};
	if($@){
	    throw Affelio::exception::DBException($af->{db}->errstr);
	}

	debug_print("get_permission end.");
	return($sth);
    }


    ########################################################################
    #(4)get_permission_by_pid
    ########################################################################
    sub get_permission_by_pid{         #return SQL_result
	my $self = shift;
	my $pid = shift;         #arg(1) IN int pid

	debug_print("get_permission_by_pid pid[$pid]");
	my $af = $self->{af};
	
	my $query = 'SELECT * FROM AFuser_CORE_permission WHERE pid = ?';

	my $sth;
	eval{
	    $sth = $af->{db}->prepare($query);
	    $sth->execute($pid);
	};
	if($@){
	    throw Affelio::exception::DBException($af->{db}->errstr);
	}

	debug_print("get_permission_by_pid end.");
	return($sth);
    }

    ########################################################################
    #(5)remove_permission_by_pid
    ########################################################################
    sub remove_permission_by_pid{
	my $self = shift;
	my $pid = shift;         #arg(1) IN int pid

	debug_print("remove_permission_by_pid pid[$pid]");
	my $af = $self->{af};
	
	my $query = 'DELETE FROM AFuser_CORE_permission WHERE pid = ?';
	my $sth;
	eval{
	    $sth = $af->{db}->prepare($query);
	    $sth->execute($pid);
	};
	if($@){
	    throw Affelio::exception::DBException($af->{db}->errstr);
	}
	
	debug_print("remove_permission_by_pid end.");
    }

    ########################################################################
    #(6)get_all_permission
    #sub SQL_result get_all_permission
    #result (pid, type, target, a, b, c, d .....)
    ########################################################################
    sub get_all_permission{
	my $self = shift;

	debug_print("get_all_premission: start");
	my $af = $self->{af};

	##############################
	#retrieve all permission records from DB
	my $query = 'SELECT * FROM AFuser_CORE_permission';

	my $sth;
	eval{
	    $sth = $af->{db}->prepare($query);
	    $sth->execute;
	};
	if($@){
	    throw Affelio::exception::DBException($af->{db}->errstr);
	}

	debug_print("get_all_premission: end");
	return($sth);
    }


}#package
1;

