# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: Email.pm,v 1.5 2005/07/01 02:00:09 slash5234 Exp $

package Affelio::NetLib::Email; 
{
    use strict;
    use lib("../../../extlib");
    use Exporter;
    use Jcode;
    use lib("../../../lib");
    use Affelio::misc::Debug;
    @Affelio::NetLib::Email::ISA = "Exporter";
    @Affelio::NetLib::Email::EXPORT = qw (encode_mail_subject send_email);

    ########################################################################
    #send_email
    ########################################################################
    sub send_email{
	my $af = shift;
	my $from = shift;
	my $to = shift;
	my $title = shift;
	my $body = shift;

        ###########################################
	Affelio::misc::Debug::debug_print("send_mail_ack: $af->{cmd__sendmail} -t\n");
	#Sendmail
	open(MAIL, " |  $af->{cmd__sendmail} -t ");
	print MAIL "To: $to\n";
	print MAIL "From: $from\n";
	print MAIL "Subject: $title\n\n";
	print MAIL "$body\n";
	print MAIL "\n";
	close(MAIL);
    }


    ########################################################################
    #encode_mail_subject
    ########################################################################
    sub encode_mail_subject {
	my($String) = @_;
#	&jcode::convert(\$String, "euc");
#	$String = jcode($String)->euc;
	my($Base64Table) = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'.
	    'abcdefghijklmnopqrstuvwxyz'.
	    '0123456789+/';
	my($chunk, $ByteChunk, $PackedByteChunk, $DecimalNum, $EncodedString);
	my($SplitedWord, @SplitedWordList, $i, $Byte, $Buff);
	my($KI) = 0;
	my($KO) = 0;
	my($CharNum) = 0;
	my($CharType) = 0;
	my($LineLength) = 0;
	my($CharEndFlag) = 1;
	if($String =~ /[^a-zA-Z0-9\!\"\#\$\%\&\'\(\)\*\+\,\-\.\/\:\;\<\=\>\?\@\[\/\^\_\~ ]/) {
	    $i = 0;
	    @SplitedWordList = ();
	    while($i < length($String)) {
		$Byte = substr($String, $i, 1);
		if($Byte =~ /[\x8E\xA1-\xFE]/) {
		    unless($CharType eq 'K') {$KI ++;}
		    $CharType = 'K';
		    if($CharEndFlag) {
			$CharEndFlag = 0;
		    } else {
			$CharEndFlag = 1;
		    }
		} else {
		    if($CharType eq 'K') {$KO ++;}
		    $CharType = 'A';
		    $CharEndFlag = 1;
		}
		$Buff .= $Byte;
		$CharNum += 1;
		$LineLength = 27 + ($CharNum*4/3) + (($KI+$KO)*4) + 2;
		if($CharType eq 'K') {$LineLength += 4;}
		if($CharEndFlag && $LineLength>=70) {
#		    &jcode::convert(\$Buff, "jis");
		    $Buff = jcode($Buff)->jis;
		    push(@SplitedWordList, $Buff);
		    $Buff = '';
		    $CharNum = 0;
		    $CharType = 0;
		    $KI = 0;
		    $KO = 0;
		}
		$i ++;
	    }
#	    &jcode::convert(\$Buff, "jis");
	    $Buff = jcode($Buff)->jis;
	    push(@SplitedWordList, $Buff);
	    
	    for $SplitedWord (@SplitedWordList) {
		$EncodedString .= '=?ISO-2022-JP?B?';
		my $BitStream = unpack("B*", $SplitedWord);
		$i = 0;
		while($chunk = substr($BitStream, $i*6, 6)) {
		    unless(length($chunk) == 6) {
			$chunk = pack("B6", $chunk);
			$chunk = unpack("B6", $chunk);
		    }
		    $ByteChunk = sprintf("%08d", $chunk);
		    $PackedByteChunk = pack("B8", $ByteChunk);
		    $DecimalNum = unpack("C", $PackedByteChunk);
		    $EncodedString .= substr($Base64Table, $DecimalNum, 1);
		    $i++;
		}
		if(length($SplitedWord) % 3 == 1) {
		    $EncodedString .= '==';
		} elsif(length($SplitedWord) % 3 == 2) {
		    $EncodedString .= '=';
		}
		$EncodedString .= '?='."\n ";
	    }
	    $EncodedString =~ s/\n $//;
	} else {
	    $EncodedString = $String;
	}
	return $EncodedString;
    }
    ########################################################################
    
}#package
1;
