# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: CGIError.pm,v 1.4 2005/07/01 02:00:10 slash5234 Exp $

use strict;

package Affelio::misc::CGIError;
{
    use Exporter;
    @Affelio::misc::CGIError::ISA = "Exporter";
    @Affelio::misc::CGIError::EXPORT = qw (error);
    $Affelio::misc::CGIError::VERSION="0.01";

    use CGI;
    use CGI::Carp qw( fatalsToBrowser );

    BEGIN{
	sub carp_error{
	    my $error_message = shift;
	    my $q = new CGI;
	    
	    my $discard_this = $q->header("text/html");
	    error ( $q, $error_message);
	}
	CGI::Carp::set_message( \&carp_error );
    }

    sub error{
	my ($q, $error_message) = @_;
	
	print $q->header("text/html"),
	$q->start_html("Affelio Error"),
	$q->h1("Affelio: We've got an error."),
	$q->p("Following error has occured."),
	$q->p('<PRE>' . $error_message),
	$q->end_html;
	exit;
    }

}
1;
