﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

using nispi.controlclass;
using nispi;

namespace nispi.Analysis
{
    class AnalysisLinkControls
    {
        public FormParts alFormParts;
        public BrowserParts browserParts;

        public AnalysisLink analysisLinkView;

        AnalysisLinkControlsEvent analysisLinkControlsEvent;

        public AnalysisLinkControls(AnalysisLink analysisLinkView)
        {
            this.analysisLinkView = analysisLinkView;

            alFormParts = FormPartsManager.Pop();
            alFormParts.Text = "リンク抽出";
            alFormParts.Name = "isPopUp";
            //aiFormParts.control.SuspendLayout();
            alFormParts.Show();
            //サイズを決定
            //alFormParts.control.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
            alFormParts.Size = new Size(Const.form.mainForm.Size.Width / 2, Const.form.mainForm.Size.Height / 2);//Const.form.boardListTabControlParts.Size;



            if (MainFormConst.formShowStyle.NOW_TYPE.Equals("TYPE1") == true)
            {
                /*amFormParts.Location = new Point(System.Windows.Forms.Cursor.Position.X - (amFormParts.Size.Width / 2),
                    System.Windows.Forms.Cursor.Position.Y - amFormParts.Size.Height - 5);*/
                alFormParts.Location = Const.form.boardListTabControlParts.PointToScreen();
            }
            else if (MainFormConst.formShowStyle.NOW_TYPE.Equals("TYPE2") == true)
            {
                /*amFormParts.Location = new Point(System.Windows.Forms.Cursor.Position.X - (amFormParts.Size.Width),
                    System.Windows.Forms.Cursor.Position.Y + 5);*/
                alFormParts.Location = Const.form.boardIndexTabControlParts.PointToScreen();
            }

            alFormParts.Owner = Const.form.mainForm.GetControl();

            browserParts = BrowserCtrlManager.Pop();
            browserParts.ownerForm = alFormParts;
            browserParts.nonTextMenuOn = false;
            browserParts.textMenuOn = false;
            browserParts.Location = new Point(1, 1);
            browserParts.Size = new Size(Const.form.mainForm.Size.Width / 2 - Scale.GetBrowserControlMinusSize().Width, 
                Const.form.mainForm.Size.Height / 2 - Scale.GetBrowserControlMinusSize().Height);
            browserParts.Name = "AnalysisLink";

            alFormParts.AddControl(browserParts);


            analysisLinkControlsEvent = new AnalysisLinkControlsEvent(this.analysisLinkView, this);
        }

        public void RemoveControls()
        {
            //タブに登録されているコントロールを全削除            
            analysisLinkControlsEvent.RemoveEvent();

            alFormParts.RemoveAllCtrl();

            alFormParts.Name = "";

            alFormParts.Hide();

            //コントロールを元に戻す
            FormPartsManager.Push(alFormParts);

            BrowserCtrlManager.Push(browserParts);
        }
    }
}
