﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

using nispi.Analysis;

namespace nispi.controlclass
{
    class AnalysisMecabControlsEvent
    {
        AnalysisMecab analysisMecabView;
        AnalysisMecabControls analysisMecabControls;

        public AnalysisMecabControlsEvent(AnalysisMecab analysisMecabView, AnalysisMecabControls analysisMecabControls)
        {
            this.analysisMecabView = analysisMecabView;
            this.analysisMecabControls = analysisMecabControls;

            analysisMecabControls.amFormParts.control.SizeChanged += new EventHandler(control_SizeChanged);
            
            this.analysisMecabControls.amFormParts.SetFormClosing(new FormPartsDelegate.MultiFormClosingEventHandler(amForm_FormClosing));//.FormClosing += new FormClosingEventHandler(amForm_FormClosing);
        }

        public void RemoveEvent()
        {
            analysisMecabControls.amFormParts.control.SizeChanged -= new EventHandler(control_SizeChanged);

            this.analysisMecabControls.amFormParts.ReSetFormClosing();
            //this.analysisMecabControls.amFormParts.FormClosing -= new FormClosingEventHandler(amForm_FormClosing);
        }

        public void control_SizeChanged(object sender, EventArgs e)
        {
            Form form = (Form)sender;
            this.analysisMecabControls.browserParts.Size = new Size(form.Size.Width - Scale.GetBrowserControlMinusSize().Width,
                form.Size.Height - Scale.GetBrowserControlMinusSize().Height);
        }

        private void amForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;

            //この作業をしないとメインウィンドウが閉じない。
            this.analysisMecabControls.amFormParts.Owner = null;

            this.analysisMecabView.Cloose();

            this.analysisMecabView = null;
            this.analysisMecabControls = null;
        }
    }
}
