﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;
using System.Diagnostics;

using System.Windows.Forms;
using mshtml;

using nispi.Menu;
using nispi;

namespace nispi.controlclass
{
    class CountryIndexTreeViewMenuEvent
    {
        TreeViewParts treeViewParts;
        CountryIndexTreeViewMenu mapIndexTreeViewMenu;

        public CountryIndexTreeViewMenuEvent(CountryIndexTreeViewMenu mapIndexTreeViewMenu)
        {
            this.mapIndexTreeViewMenu = mapIndexTreeViewMenu;
            mapIndexTreeViewMenu.menuItemOpenParts.Click += new EventHandler(menuItemOpen_Click);

            mapIndexTreeViewMenu.menuItemAddFavoriteParts.Click += new EventHandler(menuItemAddFavorite_Click);

            mapIndexTreeViewMenu.menuItemCopyURLParts.Click += new EventHandler(menuItemCopyURL_Click);

            mapIndexTreeViewMenu.menuItemCopyTitleParts.Click += new EventHandler(menuItemCopyTitle_Click);

            mapIndexTreeViewMenu.menuItemOpenBrowserParts.Click += new EventHandler(menuItemOpenBrowser_Click);

            MapMainFormConst.countryIndexTabMain.countryIndexView.countryIndexControls.treeViewParts.MouseUp +=
                new MouseEventHandler(list_View_MouseUp);
            MapMainFormConst.countryIndexTabMain.countryIndexView.countryIndexControls.treeViewParts.MouseDown +=
                new MouseEventHandler(list_View_MouseDown);

            MapMainFormConst.countryIndexTabMain.japanIndexView.countryIndexControls.treeViewParts.MouseUp +=
                new MouseEventHandler(list_View_MouseUp);
            MapMainFormConst.countryIndexTabMain.japanIndexView.countryIndexControls.treeViewParts.MouseDown +=
                new MouseEventHandler(list_View_MouseDown);
        }

        public void Show(Point point)
        {
            mapIndexTreeViewMenu.contextMenuStripParts.Show(this.treeViewParts, point);
        }

        public bool CheckConsistency()
        {
            try
            {
                if (Const.mapForm.CountryIndexTabControlParts.SelectedIndex == 0)
                    treeViewParts = MapMainFormConst.countryIndexTabMain.countryIndexView.countryIndexControls.treeViewParts;
                else
                    treeViewParts = MapMainFormConst.countryIndexTabMain.japanIndexView.countryIndexControls.treeViewParts;
                return true;
            }
            catch
            {
                return false;
            }
        }

        private void menuItemOpen_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == true)
            {
                try
                {
                    string name = treeViewParts.SelectedNodeName;
                    if (name.Length > 0)
                    {
                        try
                        {
                            BoardDataBase.GetName(name);
                        }
                        catch
                        {
                            return;
                        }
                        MainFormConst.ShowBoard(name);//.ShowBoard(name);
                    }
                }
                catch { ;}
            }
        }

        private void menuItemDownload_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == true)
            {
                try
                {
                    string url = treeViewParts.SelectedNodeName;
                    string thread_name = BoardDataBase.GetName(url);
                }
                catch
                {
                    return;
                }
            }
        }
        private void menuItemAddFavorite_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == true)
            {
                try
                {
                    string url = treeViewParts.SelectedNodeName;
                    string boardName = BoardDataBase.GetName(url);
                    string type = Util.BoardUrlToBoardTypeName(url);

                    FavoriteBoardManager.Add(boardName, url, type);
                    FavoriteBoardManager.Save();
                }
                catch
                {
                    return;
                }
            }
        }

        private void menuItemCopyURL_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == true)
            {
                string url = treeViewParts.SelectedNodeName;
                Clipboard.SetDataObject(url, true);
            }
        }

        private void menuItemCopyTitle_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == true)
            {
                try
                {
                    string url = treeViewParts.SelectedNodeName;
                    string thread_name = BoardDataBase.GetName(url);
                    Clipboard.SetDataObject(thread_name, true);
                }
                catch
                {
                    return;
                }
            }
        }

        private void menuItemOpenBrowser_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == true)
            {
                try
                {
                    string url = treeViewParts.SelectedNodeName;
                    if (url.Length != 0)
                        Process.Start(url);
                }
                catch
                {
                    return;
                }
            }
        }

        private void list_View_MouseUp(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                this.Show(e.Location);
            }
        }

        private void list_View_MouseDown(object sender, MouseEventArgs e)
        {
            if (CheckConsistency() == true)
            {
                if (e.Button == MouseButtons.Right)
                {
                    //お気に入りか、２ｃｈのインデックスか
                    if (Const.form.boardIndexTabControlParts.SelectedIndex == 0)
                    {
                        if ((treeViewParts.SelectedNodeGetBool() == false) || (treeViewParts.SelectedNodeName.Length == 0))
                        {
                            this.mapIndexTreeViewMenu.menuItemOpenParts.Enabled = false;
                            this.mapIndexTreeViewMenu.menuItemAddFavoriteParts.Enabled = false;
                            this.mapIndexTreeViewMenu.menuItemOpenBrowserParts.Enabled = false;
                            this.mapIndexTreeViewMenu.menuItemCopyURLParts.Enabled = false;
                            this.mapIndexTreeViewMenu.menuItemCopyTitleParts.Enabled = false;
                        }
                        else
                        {
                            this.mapIndexTreeViewMenu.menuItemOpenParts.Enabled = true;
                            this.mapIndexTreeViewMenu.menuItemAddFavoriteParts.Enabled = true;
                            this.mapIndexTreeViewMenu.menuItemOpenBrowserParts.Enabled = true;
                            this.mapIndexTreeViewMenu.menuItemCopyURLParts.Enabled = true;
                            this.mapIndexTreeViewMenu.menuItemCopyTitleParts.Enabled = true;
                        }
                    }
                    else
                    {
                        if ((treeViewParts.SelectedNodeGetBool() == false) || (treeViewParts.SelectedNodeName.Length == 0))
                        {
                            this.mapIndexTreeViewMenu.menuItemOpenParts.Enabled = false;
                            this.mapIndexTreeViewMenu.menuItemAddFavoriteParts.Enabled = false;
                            this.mapIndexTreeViewMenu.menuItemOpenBrowserParts.Enabled = false;
                            this.mapIndexTreeViewMenu.menuItemCopyURLParts.Enabled = false;
                            this.mapIndexTreeViewMenu.menuItemCopyTitleParts.Enabled = false;
                        }
                        else
                        {
                            this.mapIndexTreeViewMenu.menuItemOpenParts.Enabled = true;
                            this.mapIndexTreeViewMenu.menuItemAddFavoriteParts.Enabled = false;
                            this.mapIndexTreeViewMenu.menuItemOpenBrowserParts.Enabled = true;
                            this.mapIndexTreeViewMenu.menuItemCopyURLParts.Enabled = true;
                            this.mapIndexTreeViewMenu.menuItemCopyTitleParts.Enabled = true;
                        }
                    }
                }
            }
        }
    }
}