﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Threading;

using nispi.controlclass;

namespace nispi.Menu
{
    class ListViewMenu
    {
        public ContextMenuStripParts contextMenuStripParts;

        public ToolStripMenuItemParts menuItemDownloadParts;
        public ToolStripMenuItemParts menuItemAddFavoriteParts;
        public ToolStripMenuItemParts menuItemAlreadyReadParts;
        public ToolStripMenuItemParts menuItemNotReadParts;
        public ToolStripMenuItemParts menuItemCopyURLParts;
        public ToolStripMenuItemParts menuItemCopyTitleParts;
        //public ToolStripMenuItemParts menuItemSelectAllParts;
        public ToolStripMenuItemParts menuItemDeleteLogParts;
        public ToolStripMenuItemParts menuItemSaveHtmlParts;
        public ToolStripMenuItemParts menuItemSaveDatParts;
        public ToolStripMenuItemParts menuItemOpenBrowserParts;
        public ToolStripMenuItemParts menuItemReloadParts;

        public ListViewPartMenuEvent listViewPartMenuEvent;

        public ListViewMenu()
        {
            contextMenuStripParts = ContextMenuStripPartsManager.Pop();

            menuItemDownloadParts = ToolStripMenuItemPartsManager.Pop();
            menuItemAddFavoriteParts = ToolStripMenuItemPartsManager.Pop();
            menuItemAlreadyReadParts = ToolStripMenuItemPartsManager.Pop();
            menuItemNotReadParts = ToolStripMenuItemPartsManager.Pop();
            menuItemCopyURLParts = ToolStripMenuItemPartsManager.Pop();
            menuItemCopyTitleParts = ToolStripMenuItemPartsManager.Pop();
            //menuItemSelectAllParts = ToolStripMenuItemPartsManager.Pop();
            menuItemDeleteLogParts = ToolStripMenuItemPartsManager.Pop();
            menuItemSaveHtmlParts = ToolStripMenuItemPartsManager.Pop();
            menuItemSaveDatParts = ToolStripMenuItemPartsManager.Pop();
            menuItemOpenBrowserParts = ToolStripMenuItemPartsManager.Pop();
            menuItemReloadParts = ToolStripMenuItemPartsManager.Pop();

            menuItemDownloadParts.Text = "開く";

            menuItemAddFavoriteParts.Text = "お気に入りに追加する";

            menuItemAlreadyReadParts.Text = "既読にする";

            menuItemNotReadParts.Text = "未読にする";

            menuItemCopyURLParts.Text = "URLをコピー";

            menuItemCopyTitleParts.Text = "名前をコピー";

            //menuItemSelectAllParts.Text = "すべて選択";

            menuItemDeleteLogParts.Text = "ログを削除する";

            menuItemSaveHtmlParts.Text = "HTML形式で保存";

            menuItemSaveDatParts.Text = "DAT形式で保存";

            menuItemOpenBrowserParts.Text = "ブラウザで開く";

            contextMenuStripParts.ItemsAdd(menuItemDownloadParts);
            contextMenuStripParts.ItemsAdd(menuItemAddFavoriteParts);
            contextMenuStripParts.ItemsAdd(menuItemOpenBrowserParts);
            contextMenuStripParts.ItemsAdd("-");
            contextMenuStripParts.ItemsAdd(menuItemCopyURLParts);
            contextMenuStripParts.ItemsAdd(menuItemCopyTitleParts);
            contextMenuStripParts.ItemsAdd("-");
            contextMenuStripParts.ItemsAdd(menuItemAlreadyReadParts);
            contextMenuStripParts.ItemsAdd(menuItemNotReadParts);
            //contextMenuStripParts.ItemsAdd(menuItemSelectAllParts);
            contextMenuStripParts.ItemsAdd("-");
            contextMenuStripParts.ItemsAdd(menuItemDeleteLogParts);
            contextMenuStripParts.ItemsAdd(menuItemSaveHtmlParts);
            contextMenuStripParts.ItemsAdd(menuItemSaveDatParts);

            listViewPartMenuEvent = new ListViewPartMenuEvent(this);
        }
    }
}