﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

using nispi.controlclass;

namespace nispi.Menu
{
    class BoardIndexTabMenu
    {
        public ContextMenuStripParts contextMenuStripParts;

        public ToolStripMenuItemParts menuItemOpenBrowserParts;
        public ToolStripMenuItemParts menuItemCopyURLParts;
        public ToolStripMenuItemParts menuItemCopyTitleParts;
        public ToolStripMenuItemParts menuItemReloadParts;

        public BoardIndexTabEvent boardIndexTabEvent;

        public BoardIndexTabMenu()
        {
            contextMenuStripParts = ContextMenuStripPartsManager.Pop();

            menuItemOpenBrowserParts = ToolStripMenuItemPartsManager.Pop();
            menuItemCopyURLParts = ToolStripMenuItemPartsManager.Pop();
            menuItemCopyTitleParts = ToolStripMenuItemPartsManager.Pop();
            menuItemReloadParts = ToolStripMenuItemPartsManager.Pop();

            menuItemOpenBrowserParts.Text = "ブラウザーで開く";

            menuItemCopyURLParts.Text = "URLをコピー";

            menuItemCopyTitleParts.Text = "タイトルをコピー";

            menuItemReloadParts.Text = "再読み込み";

            contextMenuStripParts.ItemsAdd(menuItemOpenBrowserParts);
            contextMenuStripParts.ItemsAdd("-");
            contextMenuStripParts.ItemsAdd(menuItemCopyURLParts);
            contextMenuStripParts.ItemsAdd(menuItemCopyTitleParts);
            contextMenuStripParts.ItemsAdd("-");
            contextMenuStripParts.ItemsAdd(menuItemReloadParts);

            boardIndexTabEvent = new BoardIndexTabEvent(this);
        }
    }
}