﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;
using System.Diagnostics;

using System.Windows.Forms;
using mshtml;

using nispi.Menu;
using nispi.WriteToThread;

namespace nispi
{

    class NumberMenuEvent
    {
        public BrowserParts browserParts;
        BrowserNumberMenu browserNumberMenu;
        ThreadViewCommon threadViewCommon;
        public string number;

        public NumberMenuEvent(BrowserNumberMenu browserNumberMenu)
        {
            this.browserNumberMenu = browserNumberMenu;

            browserNumberMenu.menuItemWriteResParts.Click += new EventHandler(menuItemWriteRes_Click);
            browserNumberMenu.menuItemWriteByResParts.Click += new EventHandler(menuItemWriteByRes_Click);
            browserNumberMenu.menuItemSetShioriParts.Click += new EventHandler(menuItemSetShiori_Click);
            browserNumberMenu.menuItemOpenBrowserParts.Click += new EventHandler(menuItemOpenBrowser_Click);
            browserNumberMenu.menuItemFrontTreeParts.Click += new EventHandler(menuItemFrontTree_Click);
            browserNumberMenu.menuItemBackTreeParts.Click += new EventHandler(menuItemBackTree_Click);
            //browserNumberMenu.menuItemAllTreeParts.Click += new EventHandler(menuItemAllTree_Click);
            browserNumberMenu.menuItemExtractNameParts.Click += new EventHandler(menuItemExtractName_Click);
            browserNumberMenu.menuItemExtractIdParts.Click += new EventHandler(menuItemExtractId_Click);
            browserNumberMenu.menuItemCopyUrlParts.Click += new EventHandler(menuItemCopyUrl_Click);
            browserNumberMenu.menuItemCopyTitleParts.Click += new EventHandler(menuItemCopyTitle_Click);
        }

        public void Show(BrowserParts browserParts, Point point, string number)
        {
            this.number = number.Remove(0, 2);
            this.number = Int32.Parse(this.number).ToString();
            browserNumberMenu.contextMenuStripParts.Show(browserParts, point);
        }

        public bool CheckConsistency()
        {
            try
            {
                int index = Const.form.threadListTabControlParts.SelectedIndex;
                browserParts = MainFormConst.threadListTabMain.viewList[index].threadViewControls.browserParts;
                threadViewCommon = MainFormConst.threadListTabMain.viewList[index];
                return true;
            }
            catch
            {
                return false;
            }
        }

        public void menuItemWriteRes_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            WriteMain writeMainForm = new WriteMain(threadViewCommon.datUrl, threadViewCommon.dat.thread_name);
            //writeMainForm.SetUpTwo();
        }

        public void menuItemWriteByRes_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;
        }

        public void menuItemSetShiori_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            threadViewCommon.shiori.RemoveShiori();
            threadViewCommon.shiori.SetShiori(number);

        }

        public void menuItemOpenBrowser_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            string url = Util.DatUrlToThreadUrl(threadViewCommon.datUrl);
            Process.Start(url + number);
        }

        public void menuItemFrontTree_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            MainFormConst.PopUpWindow(Cursor.Position, threadViewCommon, threadViewCommon.datUrl, number, "fronttree");
        }

        public void menuItemBackTree_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            MainFormConst.PopUpWindow(Cursor.Position, threadViewCommon, threadViewCommon.datUrl, number, "backtree");
        }

        /*public void menuItemAllTree_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;
        }*/

        public void menuItemExtractName_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            MainFormConst.PopUpWindow(Cursor.Position, threadViewCommon, threadViewCommon.datUrl, number, "name");
        }

        public void menuItemExtractId_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            MainFormConst.PopUpWindow(Cursor.Position, threadViewCommon, threadViewCommon.datUrl, number, "id");
        }

        public void menuItemCopyUrl_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            string url = Util.DatUrlToThreadUrl(threadViewCommon.datUrl);
            Clipboard.SetDataObject(url + number, true);
        }

        public void menuItemCopyTitle_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            Clipboard.SetDataObject(threadViewCommon.threadName, true);
        }
    }
}