﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Net;
using System.IO;
using System.Threading;

namespace nispi
{
    class GetRoninSessionID
    {
        public string httpResData;
        //public int httpResDataLength;

        public MemoryStream httpResRawData;
        public int httpResRawDataLength;

        private ManualResetEvent allDone;
        
        const int BUFFER_SIZE = 4096;

        public GetRoninSessionID()
        {
            httpResData = "";
            httpResRawData = new MemoryStream();
        }

        public bool Send(string writeUrl, string postData)
        {
            byte[] postDataBytes = Encoding.ASCII.GetBytes(postData);

            allDone = new ManualResetEvent(false);

            Uri u = new Uri(writeUrl);

            HttpWebRequest req = (HttpWebRequest)WebRequest.Create(u);

            //req.KeepAlive = false;
            req.ProtocolVersion = HttpVersion.Version11;
            req.Method = "POST";
            //req.UserAgent = "Mozilla/5.0 (Windows NT 6.3; WOW64; rv:31.0) Gecko/20100101 Firefox/31.0";
            //req.AutomaticDecompression = DecompressionMethods.GZip;
            req.Timeout = 10000;
            req.Proxy = null;
            req.ContentType = "application/x-www-form-urlencoded";

            req.ContentLength = postDataBytes.Length;

            Stream postStream = req.GetRequestStream();
            postStream.Write(postDataBytes, 0, postDataBytes.Length);



            RequestState myRequestState = new RequestState();
            myRequestState.request = req;

            // Start the asynchronous request.
            IAsyncResult result =
              (IAsyncResult)req.BeginGetResponse(new AsyncCallback(RespCallback), myRequestState);

            allDone.WaitOne();

            //--レスポンスを見る
            //過去ログ落ち、人大杉//DownloadDatの受信のメソッドでnullのまま返すようにしてある
            if (myRequestState.response == null)
            {
                this.httpResData = "false1";
                return false;
            }
            else if (myRequestState.response.StatusCode == HttpStatusCode.OK)
            {
                ;
            }
            else if (myRequestState.response.StatusCode == HttpStatusCode.Redirect)
                return false;
            else
                return false;


            //--受信したデータを見る
            if ((httpResData == null) || (httpResData.Length < 1))
                return false;

            if (httpResData.StartsWith("-ERR"))
            {
                httpResData = "false2";
                return false;
            }

            myRequestState.response.Close();
            return true;
        }


        private void RespCallback(IAsyncResult asynchronousResult)
        {
            try
            {
                RequestState myRequestState = (RequestState)asynchronousResult.AsyncState;
                HttpWebRequest myHttpWebRequest = myRequestState.request;
                //人大杉の時の処理
                if (true == myHttpWebRequest.Address.AbsoluteUri.Equals("http://www2.2ch.net/live.html"))
                {
                    allDone.Set();
                    return;
                }
                try
                {
                    myRequestState.response = (HttpWebResponse)myHttpWebRequest.EndGetResponse(asynchronousResult);
                }
                catch
                {
                    //新規データが無い時にエラーが帰ることがある
                    allDone.Set();
                    return;
                }
                Stream responseStream = myRequestState.response.GetResponseStream();
                myRequestState.streamResponse = responseStream;

                try
                {
                    //読み込んでしまった本文を読み込む
                    Stream st = myRequestState.streamResponse;
                    StreamReader sr;

                    sr = new StreamReader(st, System.Text.Encoding.GetEncoding("shift-jis"));

                    string str;

                    str = sr.ReadToEnd();
                    myRequestState.responseData.Append(str);
                }
                catch { ;}

                IAsyncResult asynchronousInputRead = responseStream.BeginRead(myRequestState.BufferRead, 0, BUFFER_SIZE, new AsyncCallback(ReadCallBack), myRequestState);
                return;
            }
            catch
            { ;}
        }

        private void ReadCallBack(IAsyncResult asyncResult)
        {
            RequestState myRequestState = (RequestState)asyncResult.AsyncState;
            Stream st = myRequestState.streamResponse;
            StreamReader sr;

            sr = new StreamReader(st, System.Text.Encoding.GetEncoding("shift-jis"));

            string str;
            try
            {
                str = sr.ReadToEnd();

                if (str.Length > 0)
                {
                    myRequestState.responseData.Append(str);
                    try
                    {
                        IAsyncResult asynchronousResult = st.BeginRead(myRequestState.BufferRead, 0, BUFFER_SIZE, new AsyncCallback(ReadCallBack), myRequestState);
                        sr.Close();
                        st.Close();
                        return;
                    }
                    catch
                    {
                    }
                }
                else
                {
                }
            }
            catch { ;}

            if (myRequestState.responseData.Length > 1)
            {
                this.httpResData = myRequestState.responseData.ToString();

                Encoding sjisEnc = Encoding.GetEncoding("Shift_JIS");
                this.httpResRawDataLength = sjisEnc.GetByteCount(this.httpResData);
            }
            myRequestState.streamResponse.Close();
            //myRequestState.response.Close();
            sr.Close();
            st.Close();

            allDone.Set();
        }
    }
}