﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Runtime.InteropServices;

namespace nispi.controlclass
{
    /// <summary>
    /// タブページのスタックを作る。足りなければ新たに作成する。
    /// 多すぎればある程度まで削減する機能があってもいい
    /// </summary>
    class BrowserCtrlManager
    {
        public static Stack<BrowserParts> browserCtrlStack = new Stack<BrowserParts>();
        public static Mutex mutex = new Mutex(false, "BrowserCtrlManager");

        public static BrowserParts Pop()
        {
            mutex.WaitOne();

            if (browserCtrlStack.Count == 0)
                browserCtrlStack.Push(new BrowserParts());

            BrowserParts browserCtrl = browserCtrlStack.Pop();

            mutex.ReleaseMutex();


            return browserCtrl;
        }

        public static void Push(BrowserParts browserCtrl)
        {
            mutex.WaitOne();

            browserCtrl.ownerForm = null;
            browserCtrl.textMenuOn = true;
            browserCtrl.nonTextMenuOn = true;
            browserCtrl.BrowserClear();
            browserCtrl.ResetControl();
            browserCtrl.Update();
            
            browserCtrlStack.Push(browserCtrl);

            mutex.ReleaseMutex();
        }
    }
}
