﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Threading;

namespace nispi.controlclass
{
    /// <summary>
    /// ボタンのパーツ。ラッピング。
    /// </summary>
    ///

    class KakoLogCBoxParts:ControlBase
    {
        private ComboBox control;

        public KakoLogCBoxParts()
        {
            //コンボボックス
            control = new ComboBox();
            control.Size = new Size(100, 26);

            control.DropDownStyle = ComboBoxStyle.DropDownList;
            control.Items.Add("生存スレのみ");
            control.Items.Add("過去ログ含む");

            control.SelectedIndex = 0;

            this.controlBase = (Control)control;
        }
        public event EventHandler SelectedIndexChanged
        {
            add
            {
                this.control.SelectedIndexChanged += value;
            }
            remove
            {
                this.control.SelectedIndexChanged -= value;
            }
        }
        public int SelectedIndex
        {
            set
            {
                this.control.SelectedIndex = value;
            }
            get
            {
                return this.control.SelectedIndex;
            }
        }
    }

    class KakoLogCBoxPartsManager
    {
        public static LinkedList<KakoLogCBoxParts> allFormList = new LinkedList<KakoLogCBoxParts>();
        public static Stack<KakoLogCBoxParts> buttonStack = new Stack<KakoLogCBoxParts>();
        public static Mutex mutex = new Mutex(false, "KakoLogCBoxPartsManager");

        public static KakoLogCBoxParts Pop()
        {
            mutex.WaitOne();

            if (buttonStack.Count == 0)
                buttonStack.Push(new KakoLogCBoxParts());

            KakoLogCBoxParts buttonParts = buttonStack.Pop();

            buttonParts.SelectedIndex = 0;
            //GUIのリストを作成する
            if (null == allFormList.Find(buttonParts))
            {
                ChangeOutWard(buttonParts);
                allFormList.AddLast(buttonParts);
            }

            mutex.ReleaseMutex();

            return buttonParts;
        }

        public static void Push(KakoLogCBoxParts buttonParts)
        {
            buttonParts.ResetControlBase();

            mutex.WaitOne();

            buttonStack.Push(buttonParts);

            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard()
        {
            mutex.WaitOne();

            Const.form.mainForm.SuspendLayout();
            Const.mapForm.mapMainForm.SuspendLayout();

            foreach (KakoLogCBoxParts parts in allFormList)
            {
                parts.ForeColor = Color.FromArgb(
                    Const.opt.outWardForm.FormForeColorRed,
                    Const.opt.outWardForm.FormForeColorGreen,
                    Const.opt.outWardForm.FormForeColorBlue);
                parts.BackColor = Color.FromArgb(
                    Const.opt.outWardForm.FormBackColorRed,
                    Const.opt.outWardForm.FormBackColorGreen,
                    Const.opt.outWardForm.FormBackColorBlue);
            }

            Const.form.mainForm.Refresh();
            Const.mapForm.mapMainForm.Refresh();
            Const.form.mainForm.Update();
            Const.mapForm.mapMainForm.Update();

            Const.mapForm.mapMainForm.ResumeLayout();
            Const.form.mainForm.ResumeLayout();


            mutex.ReleaseMutex();
        }
        public static void ChangeOutWard(KakoLogCBoxParts parts)
        {
            parts.ForeColor = Color.FromArgb(
                Const.opt.outWardForm.FormForeColorRed,
                Const.opt.outWardForm.FormForeColorGreen,
                Const.opt.outWardForm.FormForeColorBlue);
            parts.BackColor = Color.FromArgb(
                Const.opt.outWardForm.FormBackColorRed,
                Const.opt.outWardForm.FormBackColorGreen,
                Const.opt.outWardForm.FormBackColorBlue);

            float scaledFloat = Scale.GetScaledFloat();

            parts.SetFont(Const.form.mainForm.GetFontName(), scaledFloat);
        }
    }
}