﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;

namespace nispi.controlclass
{
    class ContextMenuStripParts:ControlBase
    {
        private ContextMenuStrip control;
        private ToolStripProfessionalRenderer toolStripRenderer;

        public ContextMenuStripParts()
        {
            control = new ContextMenuStrip();
            this.controlBase = (Control)control;

            toolStripRenderer = new ToolStripProfessionalRenderer(new MenuColorTable()); ;
            if (Const.opt.outWardMenu.IsUseRenderer.Equals("True") == true)
                control.Renderer = toolStripRenderer;
        }

        public void Show(ControlBase targetControlBase, Point targetpoint)
        {
            this.control.Show(targetControlBase.controlBase, targetpoint);
        }

        public void ItemsAdd(ToolStripMenuItemParts parts)
        {
            this.control.Items.Add(parts.control);
        }
        public void ItemsAdd(string text)
        {
            this.control.Items.Add(text);
        }
        public void ClearItem()
        {
            this.control.Items.Clear();
        }

        public ToolStripRenderer Renderer
        {
            set
            {
                this.control.Renderer = value;
            }
            get
            {
                return this.control.Renderer;
            }
        }
    }
    /// <summary>
    /// タブページのスタックを作る。足りなければ新たに作成する。
    /// 多すぎればある程度まで削減する機能があってもいい
    /// </summary>
    class ContextMenuStripPartsManager
    {
        public static LinkedList<ContextMenuStripParts> allFormList = new LinkedList<ContextMenuStripParts>();
        public static Stack<ContextMenuStripParts> tabPageStack = new Stack<ContextMenuStripParts>();
        public static Mutex mutex = new Mutex(false, "ContextMenuStripPartsManager");

        public static ContextMenuStripParts Pop()
        {
            mutex.WaitOne();

            if (tabPageStack.Count == 0)
                tabPageStack.Push(new ContextMenuStripParts());

            ContextMenuStripParts tabPage = tabPageStack.Pop();

            //GUIのリストを作成する
            if (null == allFormList.Find(tabPage))
            {
                ChangeOutWard(tabPage);
                allFormList.AddLast(tabPage);
            }

            mutex.ReleaseMutex();

            return tabPage;
        }

        public static void Push(ContextMenuStripParts tabPage)
        {
            tabPage.ResetControlBase();

            mutex.WaitOne();

            tabPageStack.Push(tabPage);

            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard()
        {
            mutex.WaitOne();

            Const.form.mainForm.SuspendLayout();
            Const.mapForm.mapMainForm.SuspendLayout();

            foreach (ContextMenuStripParts parts in allFormList)
            {
                parts.ForeColor = Color.FromArgb(
                    Const.opt.outWardMenu.MenuSample1ForeColorRed,
                    Const.opt.outWardMenu.MenuSample1ForeColorGreen,
                    Const.opt.outWardMenu.MenuSample1ForeColorBlue);
                parts.BackColor = Color.FromArgb(
                    Const.opt.outWardMenu.MenuSample1BackColorRed,
                    Const.opt.outWardMenu.MenuSample1BackColorGreen,
                    Const.opt.outWardMenu.MenuSample1BackColorBlue);
            }

            Const.form.mainForm.Refresh();
            Const.mapForm.mapMainForm.Refresh();
            Const.form.mainForm.Update();
            Const.mapForm.mapMainForm.Update();

            Const.mapForm.mapMainForm.ResumeLayout();
            Const.form.mainForm.ResumeLayout();


            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard(ContextMenuStripParts parts)
        {
            parts.ForeColor = Color.FromArgb(
                Const.opt.outWardMenu.MenuSample1ForeColorRed,
                Const.opt.outWardMenu.MenuSample1ForeColorGreen,
                Const.opt.outWardMenu.MenuSample1ForeColorBlue);
            parts.BackColor = Color.FromArgb(
                Const.opt.outWardMenu.MenuSample1BackColorRed,
                Const.opt.outWardMenu.MenuSample1BackColorGreen,
                Const.opt.outWardMenu.MenuSample1BackColorBlue);
        }
    }
}
