﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Threading;

using nispi.Menu;

namespace nispi.controlclass
{
    /// <summary>
    /// ボタンのパーツ。ラッピング。
    /// </summary>
    /// 
    partial class TreeViewParts : ControlBase
    {
        public TreeView control;
        public TreeNode beforeHitNode = null;
        //public Color beforeForeColor;
        //public Color beforeBackColor;

        public BoardIndexViewCommon boardIndexViewCommon;

        public Color tVForeColor;

        public Color tVBackColor;
        public Color tVBackColor2;

        public Color tVSelectForeColor;
        public Color tVSelectBackColor;

        public SolidBrush tVForeBrush;

        public SolidBrush tVBackBrush;
        public SolidBrush tVBackBrush2;

        public SolidBrush tVSelectForeBrush;
        public SolidBrush tVSelectBackBrush;

        public bool WritingFlag = false;
        public Mutex mutex = new Mutex(false, "TreeViewWritingFlag");

        //Font font;
        public TreeViewParts()
        {
            this.control = new TreeView();
            control.FullRowSelect = true;

            control.DrawMode = TreeViewDrawMode.OwnerDrawAll;
            control.DrawNode += new DrawTreeNodeEventHandler(control_DrawNode);

            //control.ItemHeight = 18;
            control.Name = "boardList";
            control.ShowLines = false;
            control.Location = new Point(0, 27);
            control.MouseClick += new MouseEventHandler(boardList_listView_MouseUp);
            control.MouseDown += new MouseEventHandler(boardList_listView_MouseDown);
            control.MouseMove += new MouseEventHandler(treeView_MouseMove);

            this.controlBase = (Control)control;

            //外観の初期化
            tVForeColor = Color.FromArgb(
                255,
                Const.opt.outWardList.LVForeColorRed,
                Const.opt.outWardList.LVForeColorGreen,
                Const.opt.outWardList.LVForeColorBlue);

            tVBackColor = Color.FromArgb(
                255,
                Const.opt.outWardList.LVBackColorRed,
                Const.opt.outWardList.LVBackColorGreen,
                Const.opt.outWardList.LVBackColorBlue);

            tVBackColor2 = Color.FromArgb(
                     255,
                Const.opt.outWardList.LVBackColor2Red,
                Const.opt.outWardList.LVBackColor2Green,
                Const.opt.outWardList.LVBackColor2Blue);

            tVSelectForeColor = Color.FromArgb(
                255,
                Const.opt.outWardList.LVSelectForeColorRed,
                Const.opt.outWardList.LVSelectForeColorGreen,
                Const.opt.outWardList.LVSelectForeColorBlue);
            tVSelectBackColor = Color.FromArgb(
                255,
                Const.opt.outWardList.LVSelectBackColorRed,
                Const.opt.outWardList.LVSelectBackColorGreen,
                Const.opt.outWardList.LVSelectBackColorBlue);

            tVForeBrush = new SolidBrush(tVForeColor);
            tVBackBrush = new SolidBrush(tVBackColor);
            tVBackBrush2 = new SolidBrush(tVBackColor2);
            tVSelectForeBrush = new SolidBrush(tVSelectForeColor);
            tVSelectBackBrush = new SolidBrush(tVSelectBackColor);

            //font = new Font(Const.opt.outWardList.LVFontName, Const.opt.outWardList.LVFontSize);
            control.Font = Const.opt.outWardList.LVFont;

            control.BeforeExpand += new TreeViewCancelEventHandler(control_BeforeExpand);
            control.AfterExpand += new TreeViewEventHandler(control_AfterExpand);
        }
        public void BeginUpdate()
        {
            this.control.BeginUpdate();
        }

        public void EndUpdate()
        {
            this.control.EndUpdate();
        }

        public void control_BeforeExpand(object sender, TreeViewCancelEventArgs e)
        {
            this.control.BeginUpdate();
            //描画を停止
            this.mutex.WaitOne();
            this.WritingFlag = false;
            this.mutex.ReleaseMutex();

        }

        public void control_AfterExpand(object sender, TreeViewEventArgs e)
        {
            this.control.EndUpdate();
            //描画を再開
            this.mutex.WaitOne();
            this.WritingFlag = true;
            this.mutex.ReleaseMutex();

        }

        public bool SelectedNodeGetBool()
        {
            if (this.control.SelectedNode == null)
                return false;
            else
                return true;
        }
        
        public string SelectedNodeName
        {
            set
            {
                this.control.SelectedNode.Name = value;
            }
            get
            {
                return this.control.SelectedNode.Name;
            }
        }

        public string SelectedNodeText
        {
            set
            {
                this.control.SelectedNode.Text = value;
            }
            get
            {
                return this.control.SelectedNode.Text;
            }
        }

        public int ItemHeight
        {
            set
            {
                this.control.ItemHeight = value;
            }
            get
            {
                return this.control.ItemHeight;
            }
        }

        private void boardList_listView_MouseUp(Object sender, MouseEventArgs e)
        {
            //マウスのあるNodeを取得する
            TreeView tv = (TreeView)sender;
            TreeNode target = tv.GetNodeAt(e.X, e.Y);
            //マウス下のNodeがドロップ先として適切か調べる
            if (target != null)
            {
                beforeHitNode = target;
            }
            else
            {
                return;
            }
            if (e.Button == MouseButtons.Left)
            {
                try
                {
                    if (tv.SelectedNode.Name.Length > 0)
                    {
                        //string type = Util.BoardUrlToBoardTypeName(tv.SelectedNode.Name);
                        //string url = BoardDataBase.GetUrl(tv.SelectedNode.Text, type);
                        //boardIndexViewCommon.ShowBoard(url);
                        boardIndexViewCommon.ShowBoard(tv.SelectedNode.Name);
                    }
                }
                catch { ;}
            }                
        }

        //
        private void boardList_listView_MouseDown(Object sender, MouseEventArgs e)
        {
            //マウスのあるNodeを取得する
            TreeView tv = (TreeView)sender;
            TreeNode target = tv.GetNodeAt(e.X, e.Y);
            //マウス下のNodeがドロップ先として適切か調べる
            if (target != null)
            {
                //Nodeを選択する
                if (target.IsSelected == false)
                {
                    tv.SelectedNode = target;
                    //this.control.Invalidate();
                }
            }
            else
            {
                ;
            }
        }

        //マウスが動いた時に、フォーカスが無いのならば与える（スクロールバークリック時に対応）
        public void treeView_MouseMove(object sender, MouseEventArgs e)
        {
            TreeView treeView = (TreeView)sender;
            if (treeView.ContainsFocus == false)
            {
                //ポップアップウィンドウがある場合は無条件で消す
                if (MainFormConst.htmlPopUpWindowWidget.popUpList.Count > 0)
                {
                    MainFormConst.htmlPopUpWindowWidget.RemoveAllPopUp();
                    treeView.Focus();
                }
                if (treeView.Name.StartsWith("kokka") == false)
                {
                    if (Const.form.mainForm.ContainsFocus == true)
                    {
                        treeView.Focus();
                    }
                }
            }
        }
    }
}