﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Drawing;
using System.Xml.Linq;

using nispi;

namespace nispi.OptionControl
{
    partial class OutWardTabData : CommonInEvent
    {
        private string tabFontName;
        private float tabFontSize;

        //タブの中身の文字色
        private byte tabForeColorRed;
        private byte tabForeColorGreen;
        private byte tabForeColorBlue;
        //タブの中身の背景色
        private byte tabBackColorRed;
        private byte tabBackColorGreen;
        private byte tabBackColorBlue;
        //タブのつまむ部分の色のグラデーション
        private byte tabColorStartRed;
        private byte tabColorStartGreen;
        private byte tabColorStartBlue;
        //タブのつまむ部分のグラデーションの終わりの色
        private byte tabColorEndRed;
        private byte tabColorEndGreen;
        private byte tabColorEndBlue;

        private Mutex mutex = new Mutex(false, "OutWardTabData");

        public OutWardTabData()
        {
            GetXMLData();
        }

        private string ResetXML()
        {
            XNamespace ns = "OutWard_Tab";
            XElement doc = new XElement(ns + "Option",
                new XElement(ns + "TabFontName", "ＭＳ Ｐゴシック"),
                new XElement(ns + "TabFontSize", "12.0"),

                new XElement(ns + "TabForeColorRed", SystemColors.WindowText.R.ToString()),
                new XElement(ns + "TabForeColorGreen", SystemColors.WindowText.G.ToString()),
                new XElement(ns + "TabForeColorBlue", SystemColors.WindowText.B.ToString()),

                new XElement(ns + "TabBackColorRed", SystemColors.Window.R.ToString()),
                new XElement(ns + "TabBackColorGreen", SystemColors.Window.G.ToString()),
                new XElement(ns + "TabBackColorBlue", SystemColors.Window.B.ToString()),

                new XElement(ns + "TabColorStartRed", SystemColors.Control.R.ToString()),
                new XElement(ns + "TabColorStartGreen", SystemColors.Control.G.ToString()),
                new XElement(ns + "TabColorStartBlue", SystemColors.Control.B.ToString()),

                new XElement(ns + "TabColorEndRed", SystemColors.Control.R.ToString()),
                new XElement(ns + "TabColorEndGreen", SystemColors.Control.G.ToString()),
                new XElement(ns + "TabColorEndBlue", SystemColors.Control.B.ToString()));

            FileIO.SaveShiftJis("setting", "outward_tab.xml", doc.ToString());

            return doc.ToString();
        }

        private void GetXMLData()
        {
            mutex.WaitOne();
            string str = FileIO.ReadShiftJis("setting", "outward_tab.xml");

            if ((str == null) || (str.Length == 0))
                str = ResetXML();

            //mutex.WaitOne();
            try
            {
                XNamespace ns = "OutWard_Tab";
                XDocument doc = XDocument.Parse(str);
                XElement doc2 = doc.Element(ns + "Option");

                TabFontName = doc2.Element(ns + "TabFontName").Value;
                TabFontSize = float.Parse(doc2.Element(ns + "TabFontSize").Value);

                TabForeColorRed = Byte.Parse(doc2.Element(ns + "TabForeColorRed").Value);
                TabForeColorGreen = Byte.Parse(doc2.Element(ns + "TabForeColorGreen").Value);
                TabForeColorBlue = Byte.Parse(doc2.Element(ns + "TabForeColorBlue").Value);

                TabBackColorRed = Byte.Parse(doc2.Element(ns + "TabBackColorRed").Value);
                TabBackColorGreen = Byte.Parse(doc2.Element(ns + "TabBackColorGreen").Value);
                TabBackColorBlue = Byte.Parse(doc2.Element(ns + "TabBackColorBlue").Value);

                TabColorStartRed = Byte.Parse(doc2.Element(ns + "TabColorStartRed").Value);
                TabColorStartGreen = Byte.Parse(doc2.Element(ns + "TabColorStartGreen").Value);
                TabColorStartBlue = Byte.Parse(doc2.Element(ns + "TabColorStartBlue").Value);

                TabColorEndRed = Byte.Parse(doc2.Element(ns + "TabColorEndRed").Value);
                TabColorEndGreen = Byte.Parse(doc2.Element(ns + "TabColorEndGreen").Value);
                TabColorEndBlue = Byte.Parse(doc2.Element(ns + "TabColorEndBlue").Value);
            }
            catch { ;}
            mutex.ReleaseMutex();
        }

        public void SaveTabToFile()
        {
            mutex.WaitOne();

            XNamespace ns = "OutWard_Tab";
            XElement doc = new XElement(ns + "Option",
                new XElement(ns + "TabFontName", TabFontName),
                new XElement(ns + "TabFontSize", TabFontSize),

                new XElement(ns + "TabForeColorRed", TabForeColorRed),
                new XElement(ns + "TabForeColorGreen", TabForeColorGreen),
                new XElement(ns + "TabForeColorBlue", TabForeColorBlue),

                new XElement(ns + "TabBackColorRed", TabBackColorRed),
                new XElement(ns + "TabBackColorGreen", TabBackColorGreen),
                new XElement(ns + "TabBackColorBlue", TabBackColorBlue),

                new XElement(ns + "TabColorStartRed", TabColorStartRed),
                new XElement(ns + "TabColorStartGreen", TabColorStartGreen),
                new XElement(ns + "TabColorStartBlue", TabColorStartBlue),

                new XElement(ns + "TabColorEndRed", TabColorEndRed),
                new XElement(ns + "TabColorEndGreen", TabColorEndGreen),
                new XElement(ns + "TabColorEndBlue", TabColorEndBlue));

            FileIO.SaveShiftJis("setting", "outward_tab.xml", doc.ToString());

            mutex.ReleaseMutex();
        }

        public String TabFontName
        {
            set
            {
                mutex.WaitOne();
                this.tabFontName = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.tabFontName);
                mutex.ReleaseMutex();
                return data;
            }
        }

        public float TabFontSize
        {
            set
            {
                mutex.WaitOne();
                this.tabFontSize = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                float data = this.tabFontSize;
                mutex.ReleaseMutex();
                return data;
            }
        }

        public byte TabForeColorRed
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.tabForeColorRed = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.tabForeColorRed;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte TabForeColorGreen
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.tabForeColorGreen = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.tabForeColorGreen;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte TabForeColorBlue
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.tabForeColorBlue = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.tabForeColorBlue;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte TabBackColorRed
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.tabBackColorRed = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.tabBackColorRed;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte TabBackColorGreen
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.tabBackColorGreen = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.tabBackColorGreen;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte TabBackColorBlue
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.tabBackColorBlue = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.tabBackColorBlue;
                mutex.ReleaseMutex();
                return data;
            }
        }

    }
}
