﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

using nispi.controlclass;
namespace nispi.OptionControl
{
    //タブのタブのテキストの色と背景色とフォント、フォームの背景色、テキストの色とフォント
    //リストビュー、インデックスの背景色、選択した色、フォント

    class OutWardTab : OutWardTabData
    {
        GroupBoxParts tabGBoxParts;

        public TabControlParts tabSampleTabControlParts;
        public TabPageExParts sampleTabPageParts;
        public ButtonParts tabFontButtonParts;
        public ButtonParts tabBackColorButtonParts;
        //public ButtonParts tabForeColorButtonParts;
        public ButtonParts tabColorStartButtonParts;
        public ButtonParts tabColorEndButtonParts;
        public ButtonParts tabResetButtonParts;

        public OptionMainForm optionTabMain;

        public OutWardEventTab outWardEventTab;

        public OutWardTab(OptionMainForm optionTabMain)
        {
            this.optionTabMain = optionTabMain;
            float scaledFloat = Scale.GetScaledFloat(optionTabMain.fontSize);

            tabGBoxParts = new GroupBoxParts();
            tabSampleTabControlParts = new TabControlParts();
            sampleTabPageParts = new TabPageExParts();

            tabFontButtonParts = new ButtonParts();

            tabBackColorButtonParts = new ButtonParts();

            tabColorStartButtonParts = new ButtonParts();
            tabColorEndButtonParts = new ButtonParts();

            tabResetButtonParts = new ButtonParts();

            tabGBoxParts.Location = new Point(10, 120);
            tabGBoxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 130);
            tabGBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            tabGBoxParts.Text = "タブ";

            tabSampleTabControlParts.Location = new Point(20, 30);
            tabSampleTabControlParts.Size = new Size(200, 90);
            tabSampleTabControlParts.Name = "optionColor";
            tabSampleTabControlParts.Text = "テスト";

            sampleTabPageParts.Text = "テスト";
            tabSampleTabControlParts.AddControl(sampleTabPageParts);


            tabFontButtonParts.Location = new Point(230, 30);
            tabFontButtonParts.Size = new Size(200, 25);
            tabFontButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            tabFontButtonParts.Text = "選択されたタブの文字色";

            tabResetButtonParts.Location = new Point(optionTabMain.optionFormParts.ClientSize.Width - 130, 30);
            tabResetButtonParts.Size = new Size(100, 25);
            tabResetButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            tabResetButtonParts.Text = "元に戻す";

            tabBackColorButtonParts.Location = new Point(230, 60);
            tabBackColorButtonParts.Size = new Size(120, 25);
            tabBackColorButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            tabBackColorButtonParts.Text = "ﾀﾌﾞ内の背景色";

            //tabForeColorButtonParts.Location = new Point(360, 60);
            //tabForeColorButtonParts.Size = new Size(100, 25);
            //tabForeColorButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            //tabForeColorButtonParts.Text = "ﾀﾌﾞの文字色";

            tabColorStartButtonParts.Location = new Point(230, 90);
            tabColorStartButtonParts.Size = new Size(150, 25);
            tabColorStartButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            tabColorStartButtonParts.Text = "ﾀﾌﾞのｸﾞﾗﾃﾞｰｼｮﾝ色１";

            tabColorEndButtonParts.Location = new Point(390, 90);
            tabColorEndButtonParts.Size = new Size(150, 25);
            tabColorEndButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            tabColorEndButtonParts.Text = "ﾀﾌﾞのｸﾞﾗﾃﾞｰｼｮﾝ色２";


            optionTabMain.outWardForm.tabPageParts.AddControl(tabGBoxParts);
            tabGBoxParts.AddControl(tabSampleTabControlParts);
            tabGBoxParts.AddControl(tabFontButtonParts);
            tabGBoxParts.AddControl(tabBackColorButtonParts);
            //tabGBoxParts.AddControl(tabForeColorButtonParts);
            tabGBoxParts.AddControl(tabColorStartButtonParts);
            tabGBoxParts.AddControl(tabColorEndButtonParts);
            tabGBoxParts.AddControl(tabResetButtonParts);

            this.outWardEventTab = new OutWardEventTab(this);
        }

        public void SetDataToGUI()
        {
            this.outWardEventTab.ResetEvent();

            this.sampleTabPageParts.SetFont(TabFontName, TabFontSize);

            this.tabSampleTabControlParts.TabGradient_TabPageSelectedTextColor = Color.FromArgb(
                this.TabForeColorRed,
                this.TabForeColorGreen,
                this.TabForeColorBlue);

            this.tabSampleTabControlParts.ForeColor = Color.FromArgb(
                this.TabForeColorRed,
                this.TabForeColorGreen,
                this.TabForeColorBlue);

            this.sampleTabPageParts.BackColor = Color.FromArgb(
                this.TabBackColorRed,
                this.TabBackColorGreen,
                this.TabBackColorBlue);

            this.tabSampleTabControlParts.TabGradient_ColorStart = Color.FromArgb(
                this.TabColorStartRed,
                this.TabColorStartGreen,
                this.TabColorStartBlue);

            this.tabSampleTabControlParts.TabGradient_ColorEnd = Color.FromArgb(
                this.TabColorEndRed,
                this.TabColorEndGreen,
                this.TabColorEndBlue);

            this.outWardEventTab.SetEvent();
        }
    }
}