//CZXAgeOntH_LISENCEtH_QƂĂ
using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Diagnostics;
using System.Threading;
//using System.Threading.Tasks;
using mshtml;
using System.Windows.Forms;

using MecInfoDll;
using nispi.OptionControl;

namespace nispi
{
    class DatInfo
    {
        public string dat_url = "";
        public List<Comment> comments = new List<Comment>();
        public string thread_name = "";
        public string responseStatusCode = "";

        public DatInfo()
        {
        }
        public DatInfo(string _dat_url)
        {
            dat_url = _dat_url;
            thread_name = null;
        }

        public string Load()
        {
            //strɕςf[^ꍇ͂strp
            string str = Downloader.load_dat(dat_url);
            if (Const.OnLine == true)
            {
                string command = "";
                string downloadStr = "";

                string kakoAccessUrl = Util.DatUrlToKakoLogUrl(dat_url);
                string kakoAccessUrl2 = kakoAccessUrl.Substring(0, kakoAccessUrl.Length - 3);

                if ((str == null) || (str.Length == 0))
                    command = "S擾";
                else
                    command = "擾";

                for (int count = 0; count < 6; count += 1)
                {
                    switch (command)
                    {
                        case "S擾":
                            DownloadDat dd = new DownloadDat();
                            dd.DownloadDatData(ref responseStatusCode, ref command, dat_url);
                            downloadStr = dd.httpResData;
                            break;

                        case "擾":
                            DownloadDat dd2 = new DownloadDat();
                            dd2.DownloadDatData2(str, ref responseStatusCode, ref command, dat_url);
                            downloadStr = dd2.httpResData;
                            break;
                        // offlaw2gp
                        case "ߋOO":
                            DownloadByOfflaw2 ddOfflaw2 = new DownloadByOfflaw2();
                            string offlawUrl = Util.DatUrlToOfflaw2Path(dat_url);
                            ddOfflaw2.DownloadKakoLog(ref responseStatusCode, ref command, dat_url, offlawUrl);
                            downloadStr = ddOfflaw2.httpResData;
                            break;

                        case "ߋO@":
                            DownloadDatKako ddk = new DownloadDatKako();
                            ddk.DownloadDatData(ref responseStatusCode, ref command, kakoAccessUrl);
                            downloadStr = ddk.httpResData;
                            break;

                        case "ߋOA":
                            DownloadDat ddk2 = new DownloadDat(true);
                            // Length-3 ".gz"ȂĂ
                            ddk2.DownloadDatData(ref responseStatusCode, ref command, kakoAccessUrl.Substring(0, kakoAccessUrl.Length - 3));
                            downloadStr = ddk2.httpResData;
                            break;

                        case "ߋOB":
                            break;
                    }

                    if ((command.Length == 0) || (command.Equals("I") == true))
                    {
                        if (downloadStr.Length == 0)
                            ;
                        else
                            str = downloadStr;
                        break;
                    }
                }
            }

            return parse(str);
        }

        public string LoadFromFile()
        {
            string str = "";
            if (dat_url.Length != 0)
            {
                str = Downloader.load_dat(dat_url);
                if ((str == null) || (str.Length == 0))
                {
                    return null;
                }
            }
            return parse(str);
        }

        public string reload()
        {
            return this.Load();
        }

        public string parse(string str)
        {
            switch (Util.BoardType(dat_url))
            {
                case Util.TYPE_2CH:
                case Util.TYPE_2CHSC:
                case Util.TYPE_NEXT2CH:
                case Util.TYPE_JIKKYO:
                case Util.TYPE_BLOGBAN:
                case Util.TYPE_SHIZU:
                case Util.TYPE_VIP2CH:
                case Util.TYPE_UNKNOWN:
                    {
                        return this.parse_2ch(str);
                    }
                case Util.TYPE_OPEN2CH:
                    {
                        return this.parse_open2ch(str);
                    }
                case Util.TYPE_MACHIBBS:
                    {
                        return this.parse_machibbs(str);
                    }
                case Util.TYPE_JBBS:
                    {
                        return this.parse_jbbs(str);
                    }
            }
            return null;
        }

        public string parse_open2ch(string str)
        {
            string[] rows = str.Split(new char[] { '\r', '\n' });
            string[] items = new string[] { "" };
            int i = 0;
            string[] stringSeparators = new string[] { "<>" };

            foreach (string line in rows)
            {
                if (line == "") break;
                items = line.Split(stringSeparators, StringSplitOptions.None);

                Comment comtemp = new Comment();
                comtemp.num = Convert.ToString(i + 1);
                comtemp.name = items[0];
                comtemp.mail = items[1];
                comtemp.date = items[2];
                comtemp.body = items[3];
                if ((items.Length > 4) && (i == 0))
                    this.thread_name = items[4].ToString();
                //ID𓾂
                if (comtemp.date.Contains(" ") == true)
                {
                    string[] temp = null;
                    temp = comtemp.date.Split(' ');
                    if (temp.Length >= 2)
                    {
                        comtemp.date = temp[0];
                        comtemp.id = temp[1];
                    }
                }

                i += 1;
                this.comments.Add(comtemp);
            }

            AbonSearch();

            return save_index();
        }

        public string parse_2ch(string str)
        {
            string[] rows = str.Split(new char[] { '\r', '\n' });
            string[] items = new string[] { "" };
            int i = 0;
            string[] stringSeparators = new string[] { "<>" };

            foreach (string line in rows)
            {
                if (line == "") break;
                items = line.Split(stringSeparators, StringSplitOptions.None);

                Comment comtemp = new Comment();
                comtemp.num = Convert.ToString(i + 1);
                comtemp.name = items[0];
                comtemp.mail = items[1];
                comtemp.date = items[2];
                comtemp.body = items[3];
                if ((items.Length > 4) && (i == 0))
                    this.thread_name = items[4].ToString();
                //ID𓾂
                if (comtemp.date.Contains(" ") == true)
                {
                    string[] temp = null;
                    temp = comtemp.date.Split(' ');
                    if (temp.Length >= 2)
                        comtemp.date = temp[0] + temp[1];
                    if (temp.Length >= 3)
                        comtemp.id = temp[2];
                    //Bep̃f[^
                    if (temp.Length >= 4)
                    {
                        //"BE:774659116-2BP(1000)"

                        Regex test = new Regex(@"(.*):(.*)-(.*)\((.*)\)");

                        Match subject = null;
                        subject = test.Match(temp[3]);

                        if (subject.Groups.Count < 5)
                            continue;

                        comtemp.beID = subject.Groups[2].Value;
                        comtemp.beType = subject.Groups[3].Value;
                        comtemp.bePoint = subject.Groups[4].Value;
                    }
                }

                i += 1;
                this.comments.Add(comtemp);
            }

            AbonSearch();

            return save_index();
        }

        public string parse_machibbs(string str)
        {
            string[] rows = str.Split(new char[] { '\r', '\n' });
            string[] items = new string[] { "" };
            string[] stringSeparators = new string[] { "<>" };
            int i = 0;
            foreach (string line in rows)
            {
                if (line == "") break;
                items = line.Split(stringSeparators, StringSplitOptions.None);

                Comment comtemp = new Comment();
                comtemp.num = items[0];
                comtemp.name = items[1];
                comtemp.mail = items[2];
                comtemp.date = items[3];
                comtemp.body = items[4];
                if ((items.Length > 5) && (i == 0))
                    this.thread_name = items[5];

                if (comtemp.date.Contains(" ") == true)
                {
                    string[] temp = null;
                    temp = comtemp.date.Split(' ');
                    if (temp.Length >= 2)
                        comtemp.date = temp[0] + temp[1];
                    if (temp.Length >= 3)
                        comtemp.id = temp[2];
                }
                i += 1;
                this.comments.Add(comtemp);
            }

            AbonSearch();

            return save_index();
        }


        public string parse_jbbs(string str)
        {
            string[] rows = str.Split(new char[] { '\r', '\n' });
            string[] items = new string[] { "" };
            string[] stringSeparators = new string[] { "<>" };
            int i = 0;
            foreach (string line in rows)
            {
                if (line == "") break;
                items = line.Split(stringSeparators, StringSplitOptions.None);
                Comment comtemp = new Comment();
                comtemp.num = items[0];
                comtemp.name = items[1];
                comtemp.mail = items[2];
                comtemp.date = items[3];
                comtemp.body = items[4];
                if ((items.Length > 5) && (i == 0))
                    this.thread_name = items[5];
                if (items.Length > 6)
                    comtemp.id = "ID:" + items[6];

                i += 1;
                this.comments.Add(comtemp);
            }

            AbonSearch();

            return save_index();
        }

        public void close()
        {
            thread_name = null;
            dat_url = null;
            comments.Clear();
            comments = null;
        }

        public string save_index()
        {
            return null;
        }

        public string body(int num)
        {
            return (comments[num - 1]).body;
        }

        public void AbonSearch()
        {
            AbonData[] abonArray = Const.opt.abonOption.GetAbonDataArray();

            foreach(Comment comment in this.comments)
            {
                foreach (AbonData abonData in abonArray)
                {
                    //K\̏ꍇ
                    if (abonData.regFlag.Equals("True") == true)
                    {
                        if (abonData.flag.Equals("True") == true)
                        {
                            if (abonData.reg != null)
                            {
                                if (abonData.type.Equals("Rg") == true)
                                {
                                    if (abonData.reg.Match(comment.body).Success)
                                    {
                                        comment.abon = true;
                                        break;
                                    }
                                }
                                else if (abonData.type.Equals("O") == true)
                                {
                                    if (abonData.reg.Match(comment.name).Success)
                                    {
                                        comment.abon = true;
                                        break;
                                    }
                                }
                                else if (abonData.type.Equals("hc") == true)
                                {
                                    if (abonData.reg.Match(comment.id).Success)
                                    {
                                        comment.abon = true;
                                        break;
                                    }
                                }
                                else
                                    comment.abon = false;
                            }
                        }
                        else
                            comment.abon = false;
                    }
                    //K\ł͂Ȃꍇ
                    else if (abonData.regFlag.Equals("False") == true)
                    {
                        if (abonData.flag.Equals("True") == true)
                        {
                            if (abonData.type.Equals("Rg") == true)
                            {
                                if (comment.body.Contains(abonData.data) == true)
                                {
                                    comment.abon = true;
                                    break;
                                }
                            }
                            else if (abonData.type.Equals("O") == true)
                            {
                                if (comment.name.Contains(abonData.data) == true)
                                {
                                    comment.abon = true;
                                    break;
                                }
                            }
                            else if (abonData.type.Equals("hc") == true)
                            {
                                if (comment.id.Contains(abonData.data) == true)
                                {
                                    comment.abon = true;
                                    break;
                                }
                            }
                            else
                                comment.abon = false;
                        }
                        else
                            comment.abon = false;

                        comment.abon = false;
                    }
                }
            }
        }

    }
}