﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;
using System.Threading;

using nispi.Analysis;

namespace nispi.controlclass
{
    class AnalysisMagicControlsEvent
    {
        AnalysisMagic analysisMagicView;
        AnalysisMagicControls analysisMagicControls;

        public AnalysisMagicControlsEvent(AnalysisMagic analysisMagicView, AnalysisMagicControls analysisMagicControls)
        {
            this.analysisMagicView = analysisMagicView;
            this.analysisMagicControls = analysisMagicControls;

            this.analysisMagicControls.amFormParts.control.SizeChanged += new EventHandler(control_SizeChanged);
            this.analysisMagicControls.amFormParts.SetFormClosing(new FormPartsDelegate.MultiFormClosingEventHandler(amForm_FormClosing));
            this.analysisMagicControls.updateButttonParts.Click += new EventHandler(updateButttonParts_Click);
            this.analysisMagicControls.closeButtonParts.Click += new EventHandler(closeButtonParts_Click);
        }
        
        public void RemoveEvent()
        {
            this.analysisMagicControls.amFormParts.control.SizeChanged -= new EventHandler(control_SizeChanged);
            this.analysisMagicControls.amFormParts.ReSetFormClosing();
            this.analysisMagicControls.updateButttonParts.Click -= new EventHandler(updateButttonParts_Click);
            this.analysisMagicControls.closeButtonParts.Click -= new EventHandler(closeButtonParts_Click);
        }
        
        private void updateButttonParts_Click(object sender, EventArgs e)
        {
            this.analysisMagicView.oneLineCut = analysisMagicControls.oneLineCutCBoxParts.Checked;
            this.analysisMagicView.twoLineCut = analysisMagicControls.twoLineCutCBoxParts.Checked;
            this.analysisMagicView.threeLineCut = analysisMagicControls.threeLineCutCBoxParts.Checked;
            this.analysisMagicView.fourLineCut = analysisMagicControls.fourLineCutCBoxParts.Checked;

            this.analysisMagicView.kusaCut = analysisMagicControls.kusaCutCBoxParts.Checked;
            this.analysisMagicView.noAnchorCut = analysisMagicControls.noAnchorCutCBoxParts.Checked;

            this.analysisMagicView.threadView.ReShowThread();

            analysisMagicControls.amFormParts.Hide();
        }

        private void closeButtonParts_Click(object sender, EventArgs e)
        {
            try
            {
                analysisMagicControls.amFormParts.Hide();
            }
            catch { ;}
        }

        public void control_SizeChanged(object sender, EventArgs e)
        {
            Form form = (Form)sender;
            //this.analysisMagicControls.browserParts.Size = new Size(form.Size.Width - Scale.GetBrowserControlMinusSize().Width,
             //   form.Size.Height - Scale.GetBrowserControlMinusSize().Height);
        }



        private void amForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;

            analysisMagicControls.amFormParts.Hide();
        }
    }
}
