//CZXAgeOntH_LISENCEtH_QƂĂ

using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Text.RegularExpressions;
using System.Diagnostics;
using System.Linq;

namespace nispi
{
    class FavoriteBoardIndex
    {
        public string boardUrl = "";
        public string boardName = "";
        public string boardType = "";

        public FavoriteBoardIndex(string boardName, string boardUrl, string boardType)
        {
            this.boardName = boardName;
            this.boardUrl = boardUrl;
            this.boardType = boardType;
        }
    }

    class FavoriteBoardManager
    {
        public static List<FavoriteBoardIndex> favoriteBoardList = new List<FavoriteBoardIndex>();

        public static void LoadFavorite()
        {
            string lines = FileIO.ReadUnicode(".ageon", "favorite_board.txt");

            ParseBoardList(lines);
        }

        public static void ParseBoardList(string str)
        {
            try
            {
                FavoriteBoardManager.favoriteBoardList.Clear();
                FavoriteBoardDataBase.Clear();


                string[] rows = str.Split(new char[] { '\r', '\n' }).Where(a => a.Length > 0).ToArray();

                foreach (string line in rows)
                {
                    string[] item = line.Split(',');

                    string boardName = item[0];
                    string boardUrl = item[1];
                    string boardType = item[2];

                    if (Util.BoardUrlCheck(boardUrl) == false) continue;

                    FavoriteBoardManager.Add(boardName, boardUrl, boardType);
                }
            }
            catch
            {
                ;
            }
        }

        public static void Add(string boardName, string boardUrl, string boardType)
        {
            if (true == FavoriteBoardDataBase.RegisterName(boardUrl, boardName, boardType))
            {
                if (true == FavoriteBoardDataBase.RegisterUrl(boardUrl, boardName, boardType))
                {
                    FavoriteBoardManager.favoriteBoardList.Add(new FavoriteBoardIndex(boardName, boardUrl, boardType));

                }
            }
        }

        public static void Remove(string boardName, string boardUrl, string boardType)
        {

            FavoriteBoardManager.favoriteBoardList = FavoriteBoardManager.favoriteBoardList.Where(a =>
                ((a.boardName.Equals(boardName) == false) || (a.boardType.Equals(boardType) == false))).ToList();
        }

        public static void Save()
        {
            StringBuilder sb = new StringBuilder();
            foreach (FavoriteBoardIndex fbIndex in FavoriteBoardManager.favoriteBoardList)
            {
                sb.Append(string.Format("{0},{1},{2}\r\n", fbIndex.boardName, fbIndex.boardUrl, fbIndex.boardType));
            }
            FileIO.SaveUnicode(".ageon", "favorite_board.txt", sb.ToString());
        }
    }

    class FavoriteBoardDataBase
    {
        //@^CvƖOL[Ƃ鎫
        private static Dictionary<string, string> nameDic = new Dictionary<string, string>();
        //  ^CvURLL[Ƃ鎫
        private static Dictionary<string, string> urlDic = new Dictionary<string, string>();

        public FavoriteBoardDataBase()
        {
        }
        public static void Clear()
        {
            nameDic.Clear();
            urlDic.Clear();
        }

        public static bool RegisterName(string url, string name, string type)
        {
            try
            {
                string key = url + type;
                urlDic.Add(key, name);
                return true;
            }
            catch (System.Exception ex)
            {
                Const.debugForm.OutPutDebug("BoardIndex", ex);
                return false;
            }
        }

        public static bool RegisterUrl(string url, string name, string type)
        {
            try
            {
                string key = url + name;
                nameDic.Add(key, url);
                return true;
            }
            catch (System.Exception ex)
            {
                Const.debugForm.OutPutDebug("BoardIndex", ex);
                return false;
            }
        }

        public static string GetName(string url, string type)
        {
            try
            {
                string key = url + type;
                return urlDic[key];
            }
            catch (System.Exception ex)
            {
                Const.debugForm.OutPutDebug("BoardIndex", ex);
                return null;
            }
        }
    }
}
