﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Runtime.InteropServices;
using System.Drawing;

using nispi.controlclass;
namespace nispi
{
    class BoardListControls
    {
        public BoardViewCommon boardView;

        public TabPageExParts tabPageExParts;

        public ListViewParts listViewParts;
        public TextBoxParts searchTextBoxParts;
        public ButtonParts searchButtonParts;
        public ButtonParts extractionButtonParts;

        public PictureBoxParts separator1Pic;

        public ButtonParts reloadButtonParts;
        public ButtonParts favoriteButtonParts;
        public ButtonParts writeButtonParts;

        public PictureBoxParts separator2Pic;

        public WithInCBoxParts withInCBoxParts;
        public KakoLogCBoxParts kakoLogCBoxParts;
        public ButtonParts pinPointDateButtonParts;
        public ButtonParts timeOffButtonParts;
        
        public PictureBoxParts separator3Pic;
        
        public ButtonParts closeTabButtonParts;

        public ToolTipParts toolTipParts;

        public BoardListControlEvent boardListControlEvent;

        public BoardListControls(BoardViewCommon boardView)
        {
            this.boardView = boardView;

            tabPageExParts = TabPageExPartsManager.Pop();
            tabPageExParts.Text = "";
            tabPageExParts.Size = new Size(0, 0);

            //リストビュー
            listViewParts = ListViewPartsManager.Pop();
            listViewParts.Location = new Point(0,27);

            //検索用エディットコントロールの設定
            searchTextBoxParts = TextBoxPartsManager.Pop();
            searchTextBoxParts.Location = new Point(2, 2);
            searchTextBoxParts.Name = "search";
            searchTextBoxParts.Size = new Size(150, -1);

            //検索用ボタンの設定
            searchButtonParts = ButtonPartsManager.Pop();
            searchButtonParts.Location = new System.Drawing.Point(155, 1);
            searchButtonParts.Name = "search";
            searchButtonParts.Size = new Size(26, 26);
            searchButtonParts.Image = Resources.search;
            searchButtonParts.SetToolTip("検索");

            //抽出ボタンの設定
            extractionButtonParts = ButtonPartsManager.Pop();
            extractionButtonParts.Location = new System.Drawing.Point(185, 1);
            extractionButtonParts.Name = "search";
            extractionButtonParts.Size = new Size(26, 26);
            extractionButtonParts.Image = Resources.extraction;
            extractionButtonParts.SetToolTip("抽出");

            //セパレーター
            separator1Pic = PictureBoxPartsManager.Pop();
            separator1Pic.Image = Resources.separator;
            separator1Pic.Location = new Point(220,8);
            separator1Pic.Name = "separator";
            separator1Pic.Size = new Size(2,16);

            //リロードボタンの設定
            reloadButtonParts = ButtonPartsManager.Pop();
            reloadButtonParts.Location = new System.Drawing.Point(230, 1);
            reloadButtonParts.Name = "search";
            reloadButtonParts.Size = new Size(26, 26);
            reloadButtonParts.Image = Resources.reload;
            reloadButtonParts.SetToolTip("再読み込み");

            favoriteButtonParts = ButtonPartsManager.Pop();
            favoriteButtonParts.Location = new System.Drawing.Point(260, 1);
            favoriteButtonParts.Name = "search";
            favoriteButtonParts.Size = new Size(26, 26);
            favoriteButtonParts.Image = Resources.favorite;
            favoriteButtonParts.SetToolTip("お気に入り");
            
            writeButtonParts = ButtonPartsManager.Pop();
            writeButtonParts.Location = new System.Drawing.Point(290, 1);
            writeButtonParts.Name = "search";
            writeButtonParts.Size = new Size(26, 26);
            writeButtonParts.Image = Resources.write2;
            writeButtonParts.SetToolTip("新しい板を立てる");

            //セパレーター
            separator2Pic = PictureBoxPartsManager.Pop();
            separator2Pic.Image = Resources.separator;
            separator2Pic.Location = new Point(325, 8);
            separator2Pic.Name = "separator";
            separator2Pic.Size = new Size(2, 16);


            //コンボボックス
            kakoLogCBoxParts = KakoLogCBoxPartsManager.Pop();
            kakoLogCBoxParts.Location = new Point(335, 0);
            kakoLogCBoxParts.Name = "kakoLog";
            kakoLogCBoxParts.SelectedIndex = 0;

            //コンボボックス
            withInCBoxParts = WithInCBoxPartsManager.Pop();
            withInCBoxParts.Location = new Point(440, 0);
            withInCBoxParts.Name = "withIn";
            withInCBoxParts.SelectedIndex = 0;

            //日時指定ボタンの設定
            pinPointDateButtonParts = ButtonPartsManager.Pop();
            pinPointDateButtonParts.Location = new Point(555, 1);
            pinPointDateButtonParts.Name = "pinPointDateButtonParts";
            pinPointDateButtonParts.Size = new Size(26, 26);
            pinPointDateButtonParts.Image = Resources.calendar;
            pinPointDateButtonParts.SetToolTip("日にちを指定");


            timeOffButtonParts = ButtonPartsManager.Pop();
            timeOffButtonParts.Location = new Point(585, 1);
            timeOffButtonParts.Name = "timeOffButtonParts";
            timeOffButtonParts.Text = "リセット";
            timeOffButtonParts.Size = new Size(60, 26);

            //セパレーター
            separator3Pic = PictureBoxPartsManager.Pop();
            separator3Pic.Image = Resources.separator;
            separator3Pic.Location = new Point(655, 8);
            separator3Pic.Name = "separator";
            separator3Pic.Size = new Size(2, 16);

            closeTabButtonParts = ButtonPartsManager.Pop();
            closeTabButtonParts.Location = new System.Drawing.Point(665, 1);
            closeTabButtonParts.Name = "search";
            closeTabButtonParts.Size = new Size(26, 26);
            closeTabButtonParts.Image = Resources.close;


            this.tabPageExParts.AddControl(listViewParts);
            this.tabPageExParts.AddControl(searchTextBoxParts);
            this.tabPageExParts.AddControl(searchButtonParts);
            this.tabPageExParts.AddControl(extractionButtonParts);

            this.tabPageExParts.AddControl(separator1Pic);

            this.tabPageExParts.AddControl(reloadButtonParts);
            this.tabPageExParts.AddControl(favoriteButtonParts);
            this.tabPageExParts.AddControl(writeButtonParts);

            this.tabPageExParts.AddControl(separator2Pic);

            this.tabPageExParts.AddControl(kakoLogCBoxParts);
            this.tabPageExParts.AddControl(withInCBoxParts);
            this.tabPageExParts.AddControl(pinPointDateButtonParts);
            this.tabPageExParts.AddControl(timeOffButtonParts);

            this.tabPageExParts.AddControl(separator3Pic);

            this.tabPageExParts.AddControl(closeTabButtonParts);
            //進捗状況をみるツールチップ
            this.toolTipParts = ToolTipPartsManager.Pop();

            try
            {
                listViewParts.SizeChange();
            }
            catch
            {
                ;
            }
            
            this.boardListControlEvent = new BoardListControlEvent(this, this.boardView);
        }
        public void ResetControls()
        {
            this.boardListControlEvent.RemoveEvent();

            //null化
            tabPageExParts.Text = "";
            tabPageExParts.Name = "";
            tabPageExParts.control.ImageIndex = -1;

            kakoLogCBoxParts.SelectedIndex = 0;
            withInCBoxParts.SelectedIndex = 0;

            //pinPointDateButtonParts.Text = "日時指定";

            //listViewParts.Update();
            //listViewParts.control.Clear();
        }
        public void RemoveAllControls()
        {
            //this.boardListControlEvent.RemoveEvent();

            //タブページをタブから削除
            Const.form.boardListTabControlParts.ControlsRemove(tabPageExParts);
            


            TextBoxPartsManager.Push(searchTextBoxParts);
            ButtonPartsManager.Push(searchButtonParts);
            ButtonPartsManager.Push(extractionButtonParts);

            PictureBoxPartsManager.Push(separator1Pic);

            ButtonPartsManager.Push(reloadButtonParts);
            ButtonPartsManager.Push(favoriteButtonParts);
            ButtonPartsManager.Push(writeButtonParts);

            PictureBoxPartsManager.Push(separator2Pic);

            KakoLogCBoxPartsManager.Push(kakoLogCBoxParts);
            WithInCBoxPartsManager.Push(withInCBoxParts);
            ButtonPartsManager.Push(pinPointDateButtonParts);
            ButtonPartsManager.Push(timeOffButtonParts);

            PictureBoxPartsManager.Push(separator3Pic);

            ButtonPartsManager.Push(closeTabButtonParts);

            ListViewPartsManager.Push(listViewParts);

            ToolTipPartsManager.Push(toolTipParts);
            
            //タブに登録されているコントロールを全削除
            tabPageExParts.RemoveAllCtrl();

            //コントロールを元に戻す
            TabPageExPartsManager.Push(tabPageExParts);

            //null化
            tabPageExParts = null;

            searchTextBoxParts = null;
            searchButtonParts = null;
            reloadButtonParts = null;

            kakoLogCBoxParts = null;
            withInCBoxParts = null;

            pinPointDateButtonParts = null;
            timeOffButtonParts = null;

            listViewParts = null;
        }
    }
}