﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;
using System.Diagnostics;
using System.IO;


using System.Windows.Forms;
using mshtml;


using nispi.Menu;

namespace nispi.controlclass
{
    class MapControlTabEvent: MapControlTabMethod
    {
        MapControlTabMenu mapControlTabMenu;
        MapControlTabMainMenu mapControlTabMainMenu;

        public MapControlTabEvent(MapControlTabMenu mapControlTabMenu)
        {
            this.mapControlTabMenu = mapControlTabMenu;

            //タブコントロールのイベント
            Const.mapForm.MapControlTabControlParts.MouseUp += new MouseEventHandler(threadView_tabControl_MouseUp);
            Const.mapForm.MapControlTabControlParts.MouseDown += new MouseEventHandler(threadView_tabControl_MouseDown);

            this.mapControlTabMenu.menuItemOpenFolderParts.Click += new EventHandler(menuItemOpenFolder_Click);

            this.mapControlTabMenu.menuItemUpdateParts.Click += new EventHandler(menuItemUpdate_Click);
        }
        public MapControlTabEvent(MapControlTabMainMenu mapControlTabMainMenu)
        {
            this.mapControlTabMainMenu = mapControlTabMainMenu;

            this.mapControlTabMainMenu.menuItemOpenFolderParts.Click += new EventHandler(menuItemOpenFolder_Click);

            this.mapControlTabMainMenu.menuItemUpdateParts.Click += new EventHandler(menuItemUpdate_Click);
        }

        private void threadView_tabControl_MouseUp(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                this.mapControlTabMenu.contextMenuStripParts.Show(Const.mapForm.MapControlTabControlParts, e.Location);
            }
        }

        private void threadView_tabControl_MouseDown(object sender, MouseEventArgs e)
        {
            int selectNum = 0;
            if (e.Button == MouseButtons.Right)
            {
                for (int i = 0; i < Const.mapForm.MapControlTabControlParts.Count; i++)
                {
                    if (Const.mapForm.MapControlTabControlParts.GetTabRect(i).Contains(e.X, e.Y))
                    {
                        Const.mapForm.MapControlTabControlParts.SelectedIndex = i;
                        selectNum = i;
                    }
                }
            }
            else
            {
                return;
            }
        }
    }

    class MapControlTabMethod
    {
        public MapControlTabMethod()
        {
        }

        public bool CheckConsistency()
        {
            try
            {
                return true;
            }
            catch
            {
                return false;
            }
        }

        //ログのフォルダを開く
        public void menuItemOpenFolder_Click(object sender, EventArgs e)
        {
            string dir = Const.DataDir + Path.DirectorySeparatorChar + ".ageon"
                + Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "screening"
                + Path.DirectorySeparatorChar;

            if (System.IO.Directory.Exists(dir) == false)
            {
                System.IO.DirectoryInfo di = new System.IO.DirectoryInfo(dir);
                di.Create();
            }

            System.Diagnostics.Process.Start("EXPLORER.EXE", @"/n, " + dir);

        }

        //全情報を更新する
        public void menuItemUpdate_Click(object sender, EventArgs e)
        {
            MapMainFormConst.getScreeningData.StartScreening();
            //MapMainFormConst.getScreeningData.
        }
    }
}