﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;
using System.Diagnostics;

using System.Windows.Forms;
using mshtml;

using nispi.Menu;
using nispi;

namespace nispi.controlclass
{
    class ListViewPartMenuEvent : ListViewPartMenuMethod
    {
        public ListViewMenu listViewMenu;
        public BoardListViewMainMenu listViewMainMenu;

        public ListViewPartMenuEvent(ListViewMenu listViewMenu)
        {
            this.listViewMenu = listViewMenu;

            listViewMenu.menuItemDownloadParts.Click += new EventHandler(this.menuItemDownload_Click);

            listViewMenu.menuItemAddFavoriteParts.Click += new EventHandler(menuItemAddFavorite_Click);
            listViewMenu.menuItemAddFavoriteParts.Image = Resources.favorite;
            listViewMenu.menuItemAddFavoriteParts.ImageTransparentColor = Color.White;

            listViewMenu.menuItemAlreadyReadParts.Click += new EventHandler(menuItemAlreadyRead_Click);

            listViewMenu.menuItemNotReadParts.Click += new EventHandler(menuItemNotRead_Click);

            listViewMenu.menuItemCopyURLParts.Click += new EventHandler(menuItemCopyURL_Click);

            listViewMenu.menuItemCopyTitleParts.Click += new EventHandler(menuItemCopyTitle_Click);

            //listViewMenu.menuItemSelectAllParts.Click += new EventHandler(menuItemSelectAll_Click);

            listViewMenu.menuItemDeleteLogParts.Click += new EventHandler(menuItemDeleteLog_Click);

            listViewMenu.menuItemSaveHtmlParts.Click += new EventHandler(menuItemSaveHtml_Click);

            listViewMenu.menuItemSaveDatParts.Click += new EventHandler(menuItemSaveDat_Click);

            listViewMenu.menuItemOpenBrowserParts.Click += new EventHandler(menuItemOpenBrowser_Click);
            listViewMenu.menuItemOpenBrowserParts.Image = Resources.browser;
            listViewMenu.menuItemOpenBrowserParts.ImageTransparentColor = Color.White;
        }
        public ListViewPartMenuEvent(BoardListViewMainMenu listViewMainMenu)
        {
            this.listViewMainMenu = listViewMainMenu;

            this.listViewMainMenu.menuItemDownloadParts.Click += new EventHandler(this.menuItemDownload_Click);

            this.listViewMainMenu.menuItemAddFavoriteParts.Click += new EventHandler(menuItemAddFavorite_Click);
            this.listViewMainMenu.menuItemAddFavoriteParts.Image = Resources.favorite;
            this.listViewMainMenu.menuItemAddFavoriteParts.ImageTransparentColor = Color.White;

            this.listViewMainMenu.menuItemAlreadyReadParts.Click += new EventHandler(menuItemAlreadyRead_Click);

            this.listViewMainMenu.menuItemNotReadParts.Click += new EventHandler(menuItemNotRead_Click);

            this.listViewMainMenu.menuItemCopyURLParts.Click += new EventHandler(menuItemCopyURL_Click);

            this.listViewMainMenu.menuItemCopyTitleParts.Click += new EventHandler(menuItemCopyTitle_Click);

            //this.listViewMainMenu.menuItemSelectAllParts.Click += new EventHandler(menuItemSelectAll_Click);

            this.listViewMainMenu.menuItemDeleteLogParts.Click += new EventHandler(menuItemDeleteLog_Click);

            this.listViewMainMenu.menuItemSaveHtmlParts.Click += new EventHandler(menuItemSaveHtml_Click);

            this.listViewMainMenu.menuItemSaveDatParts.Click += new EventHandler(menuItemSaveDat_Click);

            this.listViewMainMenu.menuItemOpenBrowserParts.Click += new EventHandler(menuItemOpenBrowser_Click);
            this.listViewMainMenu.menuItemOpenBrowserParts.Image = Resources.browser;
            this.listViewMainMenu.menuItemOpenBrowserParts.ImageTransparentColor = Color.White;

        }
        public void Show(Point point)
        {
            if (CheckConsistency() == false)
                return;

            this.listViewMenu.contextMenuStripParts.Show(this.listViewParts, point);
        }
    }
    class ListViewPartMenuMethod
    {
        public BoardViewCommon boardViewCommon;

        public ListViewParts listViewParts;

        int index;

        public ListViewPartMenuMethod()
        {
        }

        public bool CheckConsistency()
        {
            try
            {
                index = Const.form.boardListTabControlParts.SelectedIndex;
                this.boardViewCommon =  MainFormConst.boardListTabMain.view_list[index];
                this.listViewParts = MainFormConst.boardListTabMain.view_list[index].boardListControls.listViewParts;
                return true;
            }
            catch
            {
                return false;
            }
        }

        //選択しているアイテムを開く
        public void menuItemDownload_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            ListViewPartMethodUtil.ChangeReadNum(this.boardViewCommon, this.listViewParts, "read");
            
            try
            {
                int count = 0;
                //複数選択に対応
                foreach (int item in listViewParts.GetSelectedIndices())
                {
                    string dat_url = listViewParts.items[item].Name;
                    string thread_name = listViewParts.items[item].SubItems_3_Text;
                    MainFormConst.ShowThread(dat_url, thread_name);
                    count += 1; if (count > 20) break;
                }
                return;

            }
            catch { ;}
        }

        //選択しているアイテムをお気に入りに加える
        public void menuItemAddFavorite_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;
            
            try
            {
                //複数選択に対応
                foreach (int num in listViewParts.GetSelectedIndices())
                {
                    string datUrl = this.listViewParts.items[num].Name;
                    string title = this.listViewParts.items[num].SubItems_3_Text;
                    string resNum = this.listViewParts.items[num].SubItems_4_Text;

                    //登録
                    MainFormConst.boardListTabMain.favoriteBoardView.Register(datUrl, title, resNum);

                }
                //再描画
                MainFormConst.boardListTabMain.favoriteBoardView.show_board("local://favorite/thread");
                return;

            }
            catch { ;}
        }

        //既読にする
        public void menuItemAlreadyRead_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            ListViewPartMethodUtil.ChangeReadNum(this.boardViewCommon, this.listViewParts, "read");
        }

 

        //未読にする
        public void menuItemNotRead_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            ListViewPartMethodUtil.ChangeReadNum(this.boardViewCommon, this.listViewParts, "nonRead");
        }


        public void menuItemSelectAll_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            listViewParts.Refresh();
        }

        public void menuItemDeleteLog_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;



            try
            {
                List<ThreadData> delDataList = new List<ThreadData>();

                foreach (int num in listViewParts.GetSelectedIndices())
                {
                    //スレッド関係
                    string datUrl = this.listViewParts.items[num].Name;

                    //スレッドのログを削除する
                    ListViewPartMethodUtil.DeleteFile(datUrl);
                    //開いているタブで該当するところがあれば削除する
                    for (int i = Const.form.threadListTabControlParts.Count - 1; i >= 0; i--)
                    {
                        if (null != MainFormConst.threadListTabMain.viewList[i].datUrl)
                        {
                            if (true == MainFormConst.threadListTabMain.viewList[i].datUrl.Equals(datUrl))
                            {
                                //通常のタブの削除の方法が行われるように選択する。
                                MainFormConst.threadListTabMain.viewList[i].dispoose();
                            }
                        }
                    }
                }

                //ブックマークの場合は板も消す
                if (this.index == 0)
                {
                    foreach (int num in listViewParts.GetSelectedIndices())
                    {
                        MainFormConst.boardListTabMain.favoriteBoardView.Delete(this.listViewParts.items[num].Name);
                    }
                }
                //再描画
                MainFormConst.boardListTabMain.favoriteBoardView.show_board("local://favorite/thread");
                return;
            }

            catch { ;}
        }

        public void menuItemSaveHtml_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            try
            {
                string datUrl = listViewParts.FocusedItem_Name;
                string fileName = Util.DatUrlToDatFileName(datUrl);
                string url = Util.DatUrlToThreadUrl(datUrl);
                fileName = fileName.Split('.')[0];
                fileName = fileName + ".html";

                string fileFullName = ListViewPartMethodUtil.OpenSaveFileDialog("html", fileName);

                if (fileFullName.Length > 0)
                {
                    DownloadFilePram param = new DownloadFilePram(url, fileFullName);

                    Thread t = new Thread(new ParameterizedThreadStart(ListViewPartMethodUtil.DownloadFileThread));
                    t.IsBackground = true;
                    t.Start((object)param);
                }
            }
            catch
            {
                return;
            }
        }
        //　ＤＡＴを保存
        public void menuItemSaveDat_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            try
            {
                string datUrl = listViewParts.FocusedItem_Name;
                string fileName = Util.DatUrlToDatFileName(datUrl);

                string fileFullName = ListViewPartMethodUtil.OpenSaveFileDialog("dat", fileName);
                if (fileFullName.Length > 0)
                {
                    DownloadFilePram param = new DownloadFilePram(datUrl, fileFullName);

                    Thread t = new Thread(new ParameterizedThreadStart(ListViewPartMethodUtil.DownloadFileThread));
                    t.IsBackground = true;
                    t.Start((object)param);
                }
            }
            catch { ;}
        }

        // ＵＲＬをコピー
        public void menuItemCopyURL_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            try
            {
                string url = Util.DatUrlToThreadUrl(listViewParts.FocusedItem_Name);
                Clipboard.SetDataObject(url, true);
            }
            catch { ;}
        }
        // スレッドのタイトルをコピー
        public void menuItemCopyTitle_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            try
            {
                string title = listViewParts.FocusedItem_SubItems_3_Text;
                Clipboard.SetDataObject(title, true);
            }
            catch { ;}
        }

        //ブラウザで開く
        public void menuItemOpenBrowser_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            try
            {
                string url = Util.DatUrlToThreadUrl(listViewParts.FocusedItem_Name);
                if (url.Length != 0)
                    Process.Start(url);
            }

            catch { ;}
        }
    }
}
