﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

using nispi.controlclass;

namespace nispi.WriteToBoard
{
    class WriteMain
    {
        public FormParts writeMainForm;

        public ButtonParts moveToFormButton;
        public ButtonParts closeWindowButton;

        public LabelParts infoLabelParts;

        public WriteFormPanel writeFormPanel;
        public WriteBrowserPanel writeBrowserPanel;

        public string MODE = "FORM";//"BROWSER";//

        public WriteMain(BoardViewCommon boardView)
        {
            ///メインフォーム
            this.writeMainForm = FormPartsManager.Pop();
            this.writeMainForm.Size = new Size(500, 500);
            this.writeMainForm.MinimumSize = new Size(400, 400);
            this.writeMainForm.Name = "WriteMainForm";
            this.writeMainForm.Text = "書き込みフォーム";
            this.writeMainForm.Hide();

            this.writeMainForm.control.FormClosing += new FormClosingEventHandler(WriteFormClosing);
            this.writeMainForm.control.Resize += new EventHandler(WriteFormResize);

            //フォームを表示するボタン
            this.moveToFormButton = ButtonPartsManager.Pop();
            this.moveToFormButton.Text = "書き込みフォームを表示する";
            this.moveToFormButton.Size = new Size(200, 30);
            this.moveToFormButton.Location = new Point(2, 2);
            this.moveToFormButton.Click += new EventHandler(moveToFormButton_Click);

            this.infoLabelParts = LabelPartsManager.Pop();
            this.infoLabelParts.Text = "";
            this.infoLabelParts.Size = new Size(270, 30);
            this.infoLabelParts.Location = new Point(210, 5);

            //ブラウザのパネル
            this.writeBrowserPanel = new WriteBrowserPanel(this, boardView.board_url, boardView.board_title);
            this.writeBrowserPanel.writeMain = this;
            this.writeBrowserPanel.myWebBrowserParts.Document.MouseUp += new HtmlElementEventHandler(Document_MouseUp);

            //書き込み用のフォームのパネル
            this.writeFormPanel = new WriteFormPanel(this, boardView.board_url, boardView.board_title);
            this.writeFormPanel.writeMain = this;
            this.writeFormPanel.postButtonParts.Click += new EventHandler(postButton_Click);
            this.writeFormPanel.resetButtonParts.Click += new EventHandler(resetButton_Click);

            SetUpTwo();

            ChangePanel("");
        }

        private void WriteFormResize(object sender, EventArgs e)
        {
            //書き込みフォーム
            this.writeFormPanel.writeFormPanelParts.Size = new Size(this.writeMainForm.Size.Width - 2, this.writeMainForm.Size.Height - 2);

            this.writeFormPanel.threadNameTextBox2Parts.Size = new Size(this.writeMainForm.Size.Width - 134, 30);
            this.writeFormPanel.boardNameLabel2Parts.Size = new Size(this.writeMainForm.Size.Width - 134, 30);

            this.writeFormPanel.contentsTextBoxParts.Size = new Size(this.writeMainForm.Size.Width - 24, this.writeMainForm.Size.Height - 210);

            this.writeFormPanel.resetButtonParts.Location = new Point(4, this.writeMainForm.Size.Height - 80);
            this.writeFormPanel.postButtonParts.Location = new Point(100, this.writeMainForm.Size.Height - 80);

            //ブラウザパーツ
            this.writeBrowserPanel.browserPanelParts.Size = new Size(this.writeMainForm.ClientSize.Width - 2, this.writeMainForm.ClientSize.Height - 34);
            this.writeBrowserPanel.myWebBrowserParts.Size = new Size(this.writeBrowserPanel.browserPanelParts.Size.Width - 2, this.writeBrowserPanel.browserPanelParts.Size.Height - 2);
        }

        private void WriteFormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;

            //イベントの削除
            this.writeMainForm.control.FormClosing -= new FormClosingEventHandler(WriteFormClosing);
            this.writeMainForm.control.Resize -= new EventHandler(WriteFormResize);
            this.moveToFormButton.Click -= new EventHandler(moveToFormButton_Click);
            this.writeBrowserPanel.myWebBrowserParts.Document.MouseUp -= new HtmlElementEventHandler(Document_MouseUp);
            this.writeFormPanel.postButtonParts.Click -= new EventHandler(postButton_Click);
            this.writeFormPanel.resetButtonParts.Click -= new EventHandler(resetButton_Click);

            this.writeBrowserPanel.browserPanelParts.RemoveAllCtrl();
            this.writeFormPanel.writeFormPanelParts.RemoveAllCtrl();
            
            this.writeMainForm.RemoveAllCtrl();
            this.writeMainForm.Name = "";
            this.writeMainForm.Hide();
            FormPartsManager.Push(this.writeMainForm);
            ButtonPartsManager.Push(this.moveToFormButton);
            LabelPartsManager.Push(this.infoLabelParts);

            PanelPartsManager.Push(this.writeBrowserPanel.browserPanelParts);
            SimpleBrowserPartsManager.Push(this.writeBrowserPanel.innerBrowserParts);
            SimpleBrowserPartsManager.Push(this.writeBrowserPanel.myWebBrowserParts);

            LabelPartsManager.Push(this.writeFormPanel.boardNameLabelParts);
            LabelPartsManager.Push(this.writeFormPanel.boardNameLabel2Parts);
            LabelPartsManager.Push(this.writeFormPanel.threadNameLabelParts);
            TextBoxPartsManager.Push(this.writeFormPanel.threadNameTextBox2Parts);

            //LabelPartsManager.Push(this.writeFormPanel.boardNameLabelParts);
            TextBoxPartsManager.Push(this.writeFormPanel.nameTextBoxParts);

            LabelPartsManager.Push(this.writeFormPanel.mailLabelParts);
            TextBoxPartsManager.Push(this.writeFormPanel.mailTextBoxParts);

            TextBoxPartsManager.Push(this.writeFormPanel.contentsTextBoxParts);

            ButtonPartsManager.Push(this.writeFormPanel.postButtonParts);
            ButtonPartsManager.Push(this.writeFormPanel.resetButtonParts);
        }

        public void SetUpTwo()
        {
            writeMainForm.Show();

            //ウィンドウの外に出ないように調節する
            if ((writeMainForm.Size.Height + writeMainForm.Location.Y) > Const.DisplayY)
            {
                writeMainForm.Location =
                    new Point(writeMainForm.Location.X,
                    writeMainForm.Location.Y - ((writeMainForm.Size.Height + writeMainForm.Location.Y) - Const.DisplayY));

                if (writeMainForm.Size.Height > Const.DisplayY)
                {
                    writeMainForm.Location = new Point(writeMainForm.Location.X, 0);
                    writeMainForm.Size = new Size(writeMainForm.Size.Width, Const.DisplayY);
                }
            }
            if ((writeMainForm.Size.Width + writeMainForm.Location.X) > Const.DisplayX)
            {
                writeMainForm.Location =
                    new Point(writeMainForm.Location.X - ((writeMainForm.Size.Width + writeMainForm.Location.X) - Const.DisplayX),
                    writeMainForm.Location.Y);
            }
        }


        private void resetButton_Click(object sender, EventArgs e)
        {
            this.writeFormPanel.nameTextBoxParts.Text = "";
            this.writeFormPanel.mailTextBoxParts.Text = "";
            this.writeFormPanel.contentsTextBoxParts.Text = "";
        }

        private void postButton_Click(object sender, EventArgs e)
        {
            // writeDataのcontentdataが無いときなどに備える
            WriteData writeData = this.writeFormPanel.writeData.CloneObject(this.writeFormPanel.writeData);

            PostData postData = new PostData(this, writeData);
            postData.Start();

            this.MODE = "BROWSER";
            this.ChangePanel("書き込み中");
        }

        public void moveToFormButton_Click(object sender, EventArgs e)
        {
            this.MODE = "FORM";

            this.ChangePanel("");
        }

        public void Document_MouseUp(object sender, HtmlElementEventArgs e)
        {
            HtmlElement clickedElement = ((HtmlDocument)sender).GetElementFromPoint(e.MousePosition);

            if (0 == e.MouseButtonsPressed.CompareTo(MouseButtons.Left))
            {
                try
                {
                    mshtml.HTMLFormElement formElement = (mshtml.HTMLFormElement)clickedElement.Parent.DomElement;
                    if (formElement.action.StartsWith("javascript:void(0);#kakunin") == true)
                    {
                        string[] addData = formElement.action.Split('?');
                        if (addData.Length == 1)
                        {
                            this.writeFormPanel.writeData.writeAddress = this.writeFormPanel.writeData.writeAddress + "?" + addData[addData.Length - 1];
                            PostData postData = new PostData(this, this.writeFormPanel.writeData);
                            postData.Start();
                        }
                        else
                        {
                            //this.writeBrowserPanel.writeData.writeAddress = this.writeBrowserPanel.writeData.writeAddress + "?" + addData[addData.Length - 1];
                            this.writeFormPanel.writeData.writeAddress = this.writeFormPanel.writeData.writeAddress + "?" + addData[addData.Length - 1];
                            PostData postData = new PostData(this, this.writeFormPanel.writeData);
                            postData.Start();
                        }
                    }
                }
                catch { ;}
            }
        }

        public void ChangePanel(string type)
        {
            Const.form.mainForm.Invoke((Action)(() => writeMainForm.RemoveAllCtrl()));

            if (this.MODE.Equals("FORM") == true)
            {
                Const.form.mainForm.Invoke((Action)(() => writeMainForm.AddControl(writeFormPanel.writeFormPanelParts)));
            }
            else if (this.MODE.Equals("BROWSER") == true)
            {
                if (type.Equals("書き込み中") == true)
                    Const.form.mainForm.Invoke((Action)(() => this.infoLabelParts.Text = "しばらくお待ちください..."));
                else
                    Const.form.mainForm.Invoke((Action)(() => this.infoLabelParts.Text = ""));

                Const.form.mainForm.Invoke((Action)(() => this.writeMainForm.AddControl(this.infoLabelParts)));
                Const.form.mainForm.Invoke((Action)(() => this.writeMainForm.AddControl(this.moveToFormButton)));
                Const.form.mainForm.Invoke((Action)(() => writeMainForm.AddControl(writeBrowserPanel.browserPanelParts)));
            }
        }
    }
}