﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

namespace nispi.controlclass
{
    partial class ListViewParts : ControlBase
    {
        public void WriteListView()
        {
            int numx = 0;
            this.Name = this.boardView.board_url;

            this.BeginUpdate();
            this.SuspendLayout();

            this.itemSize = 0;

            if (this.boardView.bvTimeExtraction.threadInfo != null)
                this.usingThreadData = this.boardView.bvTimeExtraction.threadInfo.threadDataList;
            else if (this.boardView.wordExtraction.threadInfo != null)
                this.usingThreadData = this.boardView.wordExtraction.threadInfo.threadDataList;
            else if (this.boardView.threadInfo != null)
                this.usingThreadData = this.boardView.threadInfo.threadDataList;
            else
                return;

            if (this.items != null)
            {
                foreach (ListViewItemParts item in this.items)
                    item.SubItemsClear();
            }

            this.items = new ListViewItemParts[this.usingThreadData.Count];

            foreach (ThreadData thread in usingThreadData)
            {
                string[] data = {
                                    "",
                    (numx + 1).ToString(),
					"",
                    thread.title,
					thread.resNum,
					thread.readNum,
					(Int32.Parse(thread.resNum) -Int32.Parse(thread.readNum)).ToString(),
					thread.simpleOpenTimeString,
					thread.speed,
                    thread.boardName};

                this.items[numx] = new ListViewItemParts(data);
                this.items[numx].Name = thread.datUrl;

                numx += 1;
            }
            this.itemSize = numx;

            try
            {
                this.control.Items[0].Selected = true;
                this.control.Items[0].Focused = true;
            }
            catch { ;}

            this.ResumeLayout();

            this.EndUpdate();

            //this.Update();
        }

        public void SearchListView(string searchText)
        {
            //現在選択されている所を起点とする
            int selectNum;
            try
            {
                selectNum = this.GetSelectedIndices()[0];
            }
            catch
            {
                selectNum = -1;
            }

            foreach (int num in this.GetSelectedIndices())
                this.items[num].control.Selected = false;
            try
            {
                //起点から最後まで調べる
                for (int index = selectNum + 1; control.Items.Count > index; ++index)
                {
                    //ひとつずつ調べる
                    ListViewItem item = control.Items[index];
                    if (true == item.SubItems[3].Text.Contains(searchText))
                    {
                        //選択
                        item.Selected = true;
                        //フォーカス
                        //this.threadList_listView.Focus();
                        //スクロールで移動
                        control.EnsureVisible(index);

                        return;
                    }
                }
                //選択
                control.Items[0].Selected = true;
                //フォーカス
                control.Focus();
                //スクロールで移動
                control.EnsureVisible(0);
            }
            catch { ;}
        }

        public void SizeChange()
        {
            int width = control.Size.Width - GetListViewWidth() - 25;
            if (width <= 0)
                width = 0;

            control.Columns[3].Width = width;
        }
    }
}