﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nispi.controlclass;
using System.Drawing;

namespace nispi.OptionControl
{
    //ID,名前,単語 タイプをコンボボックスで決めてリストビューに登録
    //リストビューにて有効無効を設定する
    class AbonOption : AbonOptionData
    {
        TabPageExParts tabPageParts;

        public GroupBoxParts abonGBoxParts;
        public TextBoxParts abonTBoxParts;
        public CheckBoxParts abonCheckBoxParts;
        public SimpleCBoxParts abonCBoxParts;
        public ButtonParts abonSubmitButtonParts;
        public ButtonParts abonRemoveButtonParts;
        public AbonListViewParts abonListViewParts;

        //AbonOptionData abonOptionData;
        AbonOptionEvent abonOptionEvent;

        public AbonOption(OptionMainForm optionTabMain)
            : base()
        {
            //abonOptionData = new AbonOptionData();
            float scaledFloat = Scale.GetScaledFloat(optionTabMain.fontSize);


            tabPageParts = new TabPageExParts();
            tabPageParts.SetFont(optionTabMain.fontName, scaledFloat);
            tabPageParts.Text = "あぼん";
            tabPageParts.BorderStyle = System.Windows.Forms.BorderStyle.None;

            abonGBoxParts = new GroupBoxParts();
            abonTBoxParts = new TextBoxParts();
            abonCheckBoxParts = new CheckBoxParts();
            abonCBoxParts = new SimpleCBoxParts();
            abonSubmitButtonParts = new ButtonParts();
            abonRemoveButtonParts = new ButtonParts();
            abonListViewParts = new AbonListViewParts();



            abonGBoxParts.Location = new Point(10, 10);
            abonGBoxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 480);
            abonGBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            abonGBoxParts.Text = "あぼんの登録と削除";

            abonTBoxParts.Location = new Point(20, 30);
            abonTBoxParts.Size = new Size(200, 24);
            abonTBoxParts.SetFont(optionTabMain.fontName, scaledFloat);

            abonCBoxParts.Location = new Point(230, 30);
            abonCBoxParts.Size = new Size(70, 25);
            abonCBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            abonCBoxParts.Text = "種類";
            abonCBoxParts.ItemsAdd("名前");
            abonCBoxParts.ItemsAdd("ＩＤ");
            abonCBoxParts.ItemsAdd("コメント");
            abonCBoxParts.SelectedIndex = 0;

            abonCheckBoxParts.Location = new Point(310, 30);
            abonCheckBoxParts.Size = new Size(85, 25);
            abonCheckBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            abonCheckBoxParts.Text = "正規表現";

            abonSubmitButtonParts.Location = new Point(400, 30);
            abonSubmitButtonParts.Size = new Size(50, 24);
            abonSubmitButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            abonSubmitButtonParts.Text = "登録";

            abonRemoveButtonParts.Location = new Point(460, 30);
            abonRemoveButtonParts.Size = new Size(50, 24);
            abonRemoveButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            abonRemoveButtonParts.Text = "削除";

            abonListViewParts.Location = new Point(20, 60);
            abonListViewParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 64, 400);
            abonListViewParts.VirtualMode = false;

            MakeListView();

            abonGBoxParts.AddControl(abonTBoxParts);
            abonGBoxParts.AddControl(abonCBoxParts);
            abonGBoxParts.AddControl(abonCheckBoxParts);
            abonGBoxParts.AddControl(abonSubmitButtonParts);
            abonGBoxParts.AddControl(abonRemoveButtonParts);
            abonGBoxParts.AddControl(abonListViewParts);

            tabPageParts.AddControl(abonGBoxParts);

            optionTabMain.optionTabControlParts.AddControl(tabPageParts);

            abonOptionEvent = new AbonOptionEvent(this);
        }

        public void MakeListView()
        {
            AbonData[] abonDataList = this.GetAbonDataArray();
            foreach (AbonData abonData in abonDataList)
            {
                string[] items = { abonData.data, abonData.regFlag, abonData.type, abonData.flag };
                ListViewItemParts listViewItemParts = new ListViewItemParts(items);
                abonListViewParts.AddItem(listViewItemParts);
            }
        }
        public void AddListView(AbonData abonData)
        {
            string[] items = { abonData.data, abonData.regFlag, abonData.type, abonData.flag };
            ListViewItemParts listViewItemParts = new ListViewItemParts(items);
            abonListViewParts.AddItem(listViewItemParts);

            int num = abonListViewParts.Count - 1;
            if (num < 0)
                return;

            abonListViewParts.SelectItem(num);
        }
        public void ItemsRemoveAt(int num)
        {
            abonListViewParts.ItemsRemoveAt(num);

            if (abonListViewParts.Count == num)
                num -= 1;
            
            if(num < 0)
                return;

            abonListViewParts.SelectItem(num);
        }
    }
}
