﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

using nispi.controlclass;
namespace nispi.OptionControl
{
    //タブのタブのテキストの色と背景色とフォント、フォームの背景色、テキストの色とフォント
    //リストビュー、インデックスの背景色、選択した色、フォント

    partial class OutWardBrowser
    {
        GroupBoxParts browserGBoxParts;

        public SimpleBrowserParts browserSampleParts;
        public ButtonParts browserFontButtonParts;
        public ButtonParts browserOriginalFontButtonParts;
        public ButtonParts browserBackColorButtonParts;
        public ButtonParts browserLinkColorButtonParts;
        public ButtonParts browserLinkedColorButtonParts;
        public ButtonParts browserResetButtonParts;
        public SimpleCBoxParts simpleCBoxParts;

        public OptionMainForm optionTabMain;

        public OutWardBrowser(OptionMainForm optionTabMain)
        {
            this.optionTabMain = optionTabMain;

            float scaledFloat = Scale.GetScaledFloat(optionTabMain.fontSize);
            ///
            browserGBoxParts = new GroupBoxParts();

            browserSampleParts = new SimpleBrowserParts();
            browserFontButtonParts = new ButtonParts();
            browserOriginalFontButtonParts = new ButtonParts();

            browserBackColorButtonParts = new ButtonParts();

            browserLinkColorButtonParts = new ButtonParts();
            browserLinkedColorButtonParts = new ButtonParts();
            browserResetButtonParts = new ButtonParts();

            simpleCBoxParts = new SimpleCBoxParts();

            browserSampleParts.ownerForm = optionTabMain.optionFormParts;

            browserGBoxParts.Location = new Point(10, 400);
            browserGBoxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 100);
            browserGBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            browserGBoxParts.Text = "内部ブラウザ";

            browserSampleParts.Location = new Point(20, 30);
            browserSampleParts.Size = new Size(200, 60);
            browserSampleParts.BrowserClear();

            browserFontButtonParts.Location = new Point(230, 30);
            browserFontButtonParts.Size = new Size(60, 25);
            browserFontButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            browserFontButtonParts.Text = "フォント";

            browserOriginalFontButtonParts.Location = new Point(300, 30);
            browserOriginalFontButtonParts.Size = new Size(80, 25);
            browserOriginalFontButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            browserOriginalFontButtonParts.Text = "独自ﾌｫﾝﾄ";

            browserBackColorButtonParts.Location = new Point(390, 30);
            browserBackColorButtonParts.Size = new Size(60, 25);
            browserBackColorButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            browserBackColorButtonParts.Text = "背景色";

            browserLinkColorButtonParts.Location = new Point(230, 60);
            browserLinkColorButtonParts.Size = new Size(70, 25);
            browserLinkColorButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            browserLinkColorButtonParts.Text = "リンクの色";

            browserLinkedColorButtonParts.Location = new Point(310, 60);
            browserLinkedColorButtonParts.Size = new Size(70, 25);
            browserLinkedColorButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            browserLinkedColorButtonParts.Text = "既リンクの色";

            simpleCBoxParts.Location = new Point(390, 60);
            simpleCBoxParts.Size = new Size(100, 25);
            simpleCBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            simpleCBoxParts.Text = "表示ﾃｰﾏ";
            simpleCBoxParts.ItemsAdd("AgeOnﾃｰﾏ");
            simpleCBoxParts.ItemsAdd("標準ﾃｰﾏ");
            simpleCBoxParts.SelectedIndex = 0;

            browserResetButtonParts.Location = new Point(optionTabMain.optionFormParts.ClientSize.Width - 130, 30);
            browserResetButtonParts.Size = new Size(100, 25);
            browserResetButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            browserResetButtonParts.Text = "元に戻す";

            optionTabMain.outWardForm.tabPageParts.AddControl(browserGBoxParts);
            browserGBoxParts.AddControl(browserSampleParts);
            browserGBoxParts.AddControl(browserFontButtonParts);
            browserGBoxParts.AddControl(browserOriginalFontButtonParts);
            browserGBoxParts.AddControl(browserBackColorButtonParts);
            browserGBoxParts.AddControl(browserLinkColorButtonParts);
            browserGBoxParts.AddControl(browserLinkedColorButtonParts);
            browserGBoxParts.AddControl(simpleCBoxParts);
            browserGBoxParts.AddControl(browserResetButtonParts);

            this.GetXMLData();
            this.SetEvent();
        }
        public void SetDataToGUI()
        {
            this.ResetEvent();

            browserSampleParts.BrowserClear();

            string fontSize = BrowserFontSize.ToString();
            string backColor = Convert.ToString(BrowserBackColorRed, 16).PadLeft(2, '0') +
                Convert.ToString(BrowserBackColorGreen, 16).PadLeft(2, '0') +
                Convert.ToString(BrowserBackColorBlue, 16).PadLeft(2, '0');
            string fontName = BrowserFontName;

            string foreColor = Convert.ToString(BrowserForeColorRed, 16).PadLeft(2, '0') +
                Convert.ToString(BrowserForeColorGreen, 16).PadLeft(2, '0') +
                Convert.ToString(BrowserForeColorBlue, 16).PadLeft(2, '0');

            string linkColor = Convert.ToString(BrowserLinkColorRed, 16).PadLeft(2, '0') +
                Convert.ToString(BrowserLinkColorGreen, 16).PadLeft(2, '0') +
                Convert.ToString(BrowserLinkColorBlue, 16).PadLeft(2, '0');

            string linkedColor = Convert.ToString(BrowserLinkedColorRed, 16).PadLeft(2, '0') +
                Convert.ToString(BrowserLinkedColorGreen, 16).PadLeft(2, '0') +
                Convert.ToString(BrowserLinkedColorBlue, 16).PadLeft(2, '0');

            if (this.BrowserType.Equals("ageon") == true)
                this.simpleCBoxParts.SelectedIndex = 0;
            else
                this.simpleCBoxParts.SelectedIndex = 1;

            string pointX = "0";
            string pointY = "0";
            //string htmlData = string.Format(HtmlTemplete.Header, fontSize, backColor, fontName, pointX, pointY);
            string htmlData = "";
            if (this.BrowserFontType.Equals("installed") == true)
            {
                htmlData = string.Format(HtmlTemplete.Header, fontSize, backColor, fontName, pointX, pointY);
            }
            else if (this.BrowserFontType.Equals("original") == true)
            {
                htmlData = string.Format(HtmlTemplete.HeaderOriginalFont, this.BrowserOriginalFontSize, backColor, this.BrowserOriginalFontName, this.BrowserOriginalFontPath, pointX, pointY);
            }
            htmlData += string.Format(@"<body color='#{0}' link='#{1}' vlink='#{2}'>", foreColor, linkColor, linkedColor);

            string comment = @"<font color='#" + foreColor + "'>書き込み内容</font><br>" +
                "<u><font color='" +
                linkColor +
                "'>未リンク</font></u>" +
                " <u><font color='#" +
                linkedColor +
                "'>既リンク</font></u>";
            if (this.tempBrowserType.Equals("ageon") == true)
                htmlData += string.Format(HtmlTemplete.AgeOnTheme1Sample ,linkColor, comment, foreColor);
            else
                htmlData += string.Format(HtmlTemplete.AgeOnTheme2Sample, linkColor, comment, foreColor);
            htmlData += "</body>";
            htmlData += "</html>";
            browserSampleParts.Write(htmlData);

            this.SetEvent();
        }
    }
}
