﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using nispi.controlclass;

namespace nispi.OptionControl
{
    partial class OutWardMap
    {
        public bool changeFlag = false;

        public void SetEvent()
        {
            this.mapSelectColorButtonParts.Click += new EventHandler(mapSelectColorButtonParts_Click);
            this.mapSelectColorButtonParts.Click += new EventHandler(ChangeFlag);

            this.analysisColorButtonParts.Click += new EventHandler(analysisColorButtonParts_Click);
            this.analysisColorButtonParts.Click += new EventHandler(ChangeFlag);

            this.analysisRedRButtonParts.Click += new EventHandler(analysisRedRButtonParts_Click);
            this.analysisGreenRButtonParts.Click += new EventHandler(analysisGreenRButtonParts_Click);
            this.analysisBlueRButtonParts.Click += new EventHandler(analysisBlueRButtonParts_Click);

            this.analysisRedRButtonParts.Click += new EventHandler(ChangeFlag);
            this.analysisGreenRButtonParts.Click += new EventHandler(ChangeFlag);
            this.analysisBlueRButtonParts.Click += new EventHandler(ChangeFlag);

            this.mapResetButtonParts.Click += new EventHandler(mapResetButtonParts_Click);
            this.mapResetButtonParts.Click += new EventHandler(ChangeFlag);
        }

        public void ResetEvent()
        {
            this.mapSelectColorButtonParts.Click -= new EventHandler(mapSelectColorButtonParts_Click);
            this.mapSelectColorButtonParts.Click -= new EventHandler(ChangeFlag);

            this.analysisColorButtonParts.Click -= new EventHandler(analysisColorButtonParts_Click);
            this.analysisColorButtonParts.Click -= new EventHandler(ChangeFlag);

            this.analysisRedRButtonParts.Click -= new EventHandler(analysisRedRButtonParts_Click);
            this.analysisGreenRButtonParts.Click -= new EventHandler(analysisGreenRButtonParts_Click);
            this.analysisBlueRButtonParts.Click -= new EventHandler(analysisBlueRButtonParts_Click);

            this.analysisRedRButtonParts.Click -= new EventHandler(ChangeFlag);
            this.analysisGreenRButtonParts.Click -= new EventHandler(ChangeFlag);
            this.analysisBlueRButtonParts.Click -= new EventHandler(ChangeFlag);

            this.mapResetButtonParts.Click -= new EventHandler(mapResetButtonParts_Click);
            this.mapResetButtonParts.Click -= new EventHandler(ChangeFlag);
        }

        private void ChangeFlag(object sender, EventArgs e)
        {
            this.changeFlag = true;
        }

        private void analysisRedRButtonParts_Click(object sender, EventArgs e)
        {
            this.analysisGradationPicBoxParts.Image = MakeGradationImage(
                this.analysisSampleLabelParts.BackColor.R,
                this.analysisSampleLabelParts.BackColor.G,
                this.analysisSampleLabelParts.BackColor.B,
                "Red");
            this.tempGradationColor = "Red";
        }
        private void analysisGreenRButtonParts_Click(object sender, EventArgs e)
        {
            this.analysisGradationPicBoxParts.Image = MakeGradationImage(
                this.analysisSampleLabelParts.BackColor.R,
                this.analysisSampleLabelParts.BackColor.G,
                this.analysisSampleLabelParts.BackColor.B,
                "Green");
            this.tempGradationColor = "Green";
        }
        private void analysisBlueRButtonParts_Click(object sender, EventArgs e)
        {
            this.analysisGradationPicBoxParts.Image = MakeGradationImage(
                this.analysisSampleLabelParts.BackColor.R,
                this.analysisSampleLabelParts.BackColor.G,
                this.analysisSampleLabelParts.BackColor.B,
                "Blue");
            this.tempGradationColor = "Blue";
        }
        public void mapSelectColorButtonParts_Click(object sender, EventArgs e)
        {
            ColorSet colorSet = new ColorSet();
            if (true == FormGUI.GetColor(colorSet))
            {
                //ラベルを書き換える。実データは書き換えない
                this.mapSelectSampleLabelParts.BackColor = Color.FromArgb(
                    colorSet.red,
                    colorSet.green,
                    colorSet.blue);
            }
        }

        public void analysisColorButtonParts_Click(object sender, EventArgs e)
        {
            ColorSet colorSet = new ColorSet();
            if (true == FormGUI.GetColor(colorSet))
            {
                //ラベルを書き換える。実データは書き換えない
                this.analysisSampleLabelParts.BackColor = Color.FromArgb(
                    colorSet.red,
                    colorSet.green,
                    colorSet.blue);

                this.analysisGradationPicBoxParts.Image = MakeGradationImage(
                    colorSet.red,
                    colorSet.green,
                    colorSet.blue,
                    this.tempGradationColor);
            }
        }

        //リセットをする
        public void mapResetButtonParts_Click(object sender, EventArgs e)
        {
            this.mapSelectSampleLabelParts.BackColor = Color.FromArgb(
                0,
                0,
                255);

            this.analysisSampleLabelParts.BackColor = Color.FromArgb(
                255,
                255,
                255);

            this.analysisGradationPicBoxParts.Image = MakeGradationImage(
                255,
                100,
                100,
                "Red");

            this.tempGradationColor = "Red";
        }

        public void SetAllOption()
        {
            if (changeFlag == true)
            {
                changeFlag = false;
                {
                    this.MapSelectColorRed = this.mapSelectSampleLabelParts.BackColor.R;
                    this.MapSelectColorGreen = this.mapSelectSampleLabelParts.BackColor.G;
                    this.MapSelectColorBlue = this.mapSelectSampleLabelParts.BackColor.B;

                    this.AnalysisColorRed = this.analysisSampleLabelParts.BackColor.R;
                    this.AnalysisColorGreen = this.analysisSampleLabelParts.BackColor.G;
                    this.AnalysisColorBlue = this.analysisSampleLabelParts.BackColor.B;

                    this.GradationColor = this.tempGradationColor;

                    this.SaveFormToFile();

                    //外観を変える
                }
            }
        }
    }
}
