﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace nispi.OptionControl
{
    class WriteOptionEvent
    {
        private WriteOption writeOption;
        private bool changeFlag = false;

        public WriteOptionEvent(WriteOption writeOption)
        {
            this.writeOption = writeOption;
            SetEvent();
        }
        public void SetEvent()
        {
            this.writeOption.nameTBoxParts.TextChanged += new EventHandler(ChangeFlag);
            this.writeOption.nameButtonParts.Click += new EventHandler(nameButtonParts_Click);

            this.writeOption.mailTBoxParts.TextChanged += new EventHandler(ChangeFlag);
            this.writeOption.mailButtonParts.Click += new EventHandler(mailButtonParts_Click);

            this.writeOption.sageCheckBoxParts.Click += new EventHandler(ChangeFlag);
            this.writeOption.sageCheckBoxParts.Click += new EventHandler(sageCheckBoxParts_Click);
        }
        public void ResetEvent()
        {
            this.writeOption.nameTBoxParts.TextChanged -= new EventHandler(ChangeFlag);
            this.writeOption.nameButtonParts.Click -= new EventHandler(nameButtonParts_Click);

            this.writeOption.mailTBoxParts.TextChanged -= new EventHandler(ChangeFlag);
            this.writeOption.mailButtonParts.Click -= new EventHandler(mailButtonParts_Click);

            this.writeOption.sageCheckBoxParts.Click -= new EventHandler(ChangeFlag);
            this.writeOption.sageCheckBoxParts.Click -= new EventHandler(sageCheckBoxParts_Click);
        }

        private void ChangeFlag(object sender, EventArgs e)
        {
            this.changeFlag = true;
        }

        public void nameButtonParts_Click(object sender, EventArgs e)
        {
            this.writeOption.nameTBoxParts.Text = "";
        }

        public void mailButtonParts_Click(object sender, EventArgs e)
        {
            this.writeOption.mailTBoxParts.Text = "";
        }
        
        public void sageCheckBoxParts_Click(object sender, EventArgs e)
        {
            this.writeOption.mailTBoxParts.Text = "sage";
        }

        public void SetAllOption()
        {
            if (changeFlag == true)
            {
                changeFlag = false;
                {
                    this.writeOption.WriteName = this.writeOption.nameTBoxParts.Text;
                    this.writeOption.WriteMail = this.writeOption.mailTBoxParts.Text;
                    this.writeOption.IsSageCheck = this.writeOption.sageCheckBoxParts.Checked.ToString();

                    this.writeOption.SaveToFile();
                }
            }
        }
    }
}
