﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nispi.controlclass;
using System.Drawing;

namespace nispi.OptionControl
{
    //デフォルトの名前、メアド、常にsageか。投稿履歴の管理
    class WriteOption:WriteOptionData
    {
        TabPageExParts writeOptionTabPageParts;

        GroupBoxParts nameGboxParts;
        public LabelParts nameLabelParts;
        public TextBoxParts nameTBoxParts;
        public ButtonParts nameButtonParts;

        public LabelParts mailLabelParts;
        public TextBoxParts mailTBoxParts;
        public ButtonParts mailButtonParts;

        public CheckBoxParts sageCheckBoxParts;

        public OptionMainForm optionTabMain;

        public WriteOptionEvent writeOptionEvent;

        public WriteOption(OptionMainForm optionTabMain)
        {
            this.optionTabMain = optionTabMain;
            float scaledFloat = Scale.GetScaledFloat(optionTabMain.fontSize);

            writeOptionTabPageParts = new TabPageExParts();
            writeOptionTabPageParts.SetFont(optionTabMain.fontName, scaledFloat);
            writeOptionTabPageParts.Text = "書き込み ";
            writeOptionTabPageParts.BorderStyle = System.Windows.Forms.BorderStyle.None;

            nameGboxParts = new GroupBoxParts();
            nameLabelParts = new LabelParts();
            nameTBoxParts = new TextBoxParts();
            nameButtonParts = new ButtonParts();

            mailLabelParts = new LabelParts();
            mailTBoxParts = new TextBoxParts();
            mailButtonParts = new ButtonParts();

            sageCheckBoxParts = CheckBoxPartsManager.Pop();

            nameGboxParts.Location = new Point(10, 10);
            nameGboxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 130);
            nameGboxParts.SetFont(optionTabMain.fontName, scaledFloat);
            nameGboxParts.Text = "書き込む際の設定";

            nameLabelParts.Location = new Point(20, 30);
            nameLabelParts.Size = new Size(50, 20);
            nameLabelParts.SetFont(optionTabMain.fontName, scaledFloat);
            nameLabelParts.Text = "名前：";

            nameTBoxParts.Location = new Point(80, 30);
            nameTBoxParts.Size = new Size(150, 16);
            nameTBoxParts.SetFont(optionTabMain.fontName, scaledFloat);

            nameButtonParts.Location = new Point(optionTabMain.optionFormParts.ClientSize.Width - 130, 30);
            nameButtonParts.Size = new Size(100, 25);
            nameButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            nameButtonParts.Text = "元に戻す";

            mailLabelParts.Location = new Point(20, 60);
            mailLabelParts.Size = new Size(120, 20);
            mailLabelParts.SetFont(optionTabMain.fontName, scaledFloat);
            mailLabelParts.Text = "メールアドレス：";

            mailTBoxParts.Location = new Point(150, 60);
            mailTBoxParts.Size = new Size(150, 16);
            mailTBoxParts.SetFont(optionTabMain.fontName, scaledFloat);

            mailButtonParts.Location = new Point(optionTabMain.optionFormParts.ClientSize.Width - 130, 60);
            mailButtonParts.Size = new Size(100, 25);
            mailButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            mailButtonParts.Text = "元に戻す";

            ///
            sageCheckBoxParts.Location = new Point(20, 90);
            sageCheckBoxParts.Size = new Size(160, 25);
            sageCheckBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            //sageCheckBoxParts.control.TextAlign = ContentAlignment.MiddleLeft;
            //sageCheckBoxParts.control.CheckAlign = ContentAlignment.MiddleRight;
            sageCheckBoxParts.Text = "標準でsageにする：";


            writeOptionTabPageParts.AddControl(nameGboxParts);

            nameGboxParts.AddControl(nameLabelParts);
            nameGboxParts.AddControl(nameTBoxParts);
            nameGboxParts.AddControl(nameButtonParts);

            nameGboxParts.AddControl(mailLabelParts);
            nameGboxParts.AddControl(mailTBoxParts);
            nameGboxParts.AddControl(mailButtonParts);

            nameGboxParts.AddControl(sageCheckBoxParts);

            optionTabMain.optionTabControlParts.AddControl(writeOptionTabPageParts);

            this.writeOptionEvent = new WriteOptionEvent(this);
        }
        public void SetDataToGUI()
        {
            this.writeOptionEvent.ResetEvent();

            this.nameTBoxParts.Text = this.WriteName;
            this.mailTBoxParts.Text = this.WriteMail;

            this.sageCheckBoxParts.Checked = bool.Parse(this.IsSageCheck);

            this.writeOptionEvent.SetEvent();
        }
    }
}
