﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
//UACに関して参考にしたサイト：
//https://sakapon.wordpress.com/2013/03/28/runselfasadmin/
//http://mycsharp.seesaa.net/article/386034891.html
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Security.Principal;
using System.Text; 
using System.Collections.Generic;
using System.Windows.Forms;

namespace nispi
{
    static class Program
    {
        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>

        /*[STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            MainForm form = new MainForm();
            Application.Run(form.mainForm.control);
        }*/


        [STAThread]
        static void Main()
        {
            if (IsAdmin)
            {
                // 本来の処理を実行します。
                MainAsAdmin();
            }
            else
            {
                // 自身を runas で実行します。
                RunSelfAsAdmin();
            }
        }
        [STAThread]
        static void MainAsAdmin()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            MainForm form = new MainForm();
            Application.Run(form.mainForm.control);
        }

        static bool IsAdmin
        {
            get
            {
                var principal = new WindowsPrincipal(WindowsIdentity.GetCurrent());
                return principal.IsInRole(WindowsBuiltInRole.Administrator);
            }
        }

        static void RunSelfAsAdmin()
        {
            ProcessStartInfo psi = new ProcessStartInfo();
            psi.FileName = Application.ExecutablePath;
            psi.UseShellExecute = true;
            psi.Verb = "runas";

            try
            {
                Process.Start(psi);
            }
            catch (Win32Exception ex)
            {
                // ユーザーが [いいえ] を選択すると例外が発生します。
                //Console.WriteLine(ex.Message);
            }
            Application.Exit();
        }
        
    }
}