﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;
using System.Diagnostics;
using System.IO;

using System.Windows.Forms;
using mshtml;

using nispi.Menu;

namespace nispi.controlclass
{
    class MapControlViewMenuEvent : MapControlViewMethod
    {
        MapControlViewMenu mapControlViewMenu;

        public MapControlViewMenuEvent(MapControlViewMenu mapControlViewMenu)
        {
            this.mapControlViewMenu = mapControlViewMenu;

            this.mapControlViewMenu.menuItemOpenParts.Click += new EventHandler(this.menuItemOpen_Click);

            this.mapControlViewMenu.menuItemOpenNoPopUpParts.Click += new EventHandler(menuItemOpenNoPopUp_Click);

            this.mapControlViewMenu.menuItemDeleteLogParts.Click += new EventHandler(menuItemDeleteLog_Click);

            this.mapControlViewMenu.menuItemOpenFolderParts.Click += new EventHandler(menuItemOpenFolder_Click);

            this.mapControlViewMenu.menuItemUpdateParts.Click += new EventHandler(menuItemUpdate_Click);

            //時間設定の項目
            this.mapControlViewMenu.menuItemTime30MinParts.Click += new EventHandler(this.menuItemTime_Click);

            this.mapControlViewMenu.menuItemTime1HParts.Click += new EventHandler(this.menuItemTime_Click);

            this.mapControlViewMenu.menuItemTime3HParts.Click += new EventHandler(this.menuItemTime_Click);

            this.mapControlViewMenu.menuItemTime6HParts.Click += new EventHandler(this.menuItemTime_Click);

            this.mapControlViewMenu.menuItemTime12HParts.Click += new EventHandler(this.menuItemTime_Click);

            this.mapControlViewMenu.menuItemTime24HParts.Click += new EventHandler(this.menuItemTime_Click);

            this.mapControlViewMenu.menuItemTime2DParts.Click += new EventHandler(this.menuItemTime_Click);

            this.mapControlViewMenu.menuItemTime3DParts.Click += new EventHandler(this.menuItemTime_Click);

            this.mapControlViewMenu.menuItemTime1WParts.Click += new EventHandler(this.menuItemTime_Click);

            this.mapControlViewMenu.menuItemTime2WParts.Click += new EventHandler(this.menuItemTime_Click);

            this.mapControlViewMenu.menuItemTime1MonParts.Click += new EventHandler(this.menuItemTime_Click);
        }

        public void Show(string yomi, PictureBoxParts picBoxParts, Point point)
        {
            this.yomi = yomi;
            this.mapControlViewMenu.contextMenuStripParts.Show(picBoxParts, point);
        }

    }


    class MapControlViewMethod
    {
        //public MapControlView mapControlView;
        public string yomi;

        public MapControlViewMethod()
        {
        }

        public bool CheckConsistency()
        {
            return false;
        }

        //選択しているアイテムを開く
        public void menuItemOpen_Click(object sender, EventArgs e)
        {
            MainFormConst.boardListTabMain.show_board("local://screening/" + yomi, true);
        }
        //フォームをポップアップせずに選択しているアイテムを開く
        public void menuItemOpenNoPopUp_Click(object sender, EventArgs e)
        {
            MainFormConst.boardListTabMain.show_board("local://screening/" + yomi, false);//false はポップアップ無し
        }

        //ログを削除する
        public void menuItemDeleteLog_Click(object sender, EventArgs e)
        {
            string dir = Const.DataDir + Path.DirectorySeparatorChar + ".ageon"
                 + Path.DirectorySeparatorChar + "cache"  + Path.DirectorySeparatorChar + "screening"
                 + Path.DirectorySeparatorChar + yomi;

            string[] files = Directory.GetFiles(dir, "*", SearchOption.TopDirectoryOnly);

            if (files.Length == 0)
                return;

            try
            {
                foreach (string file in files)
                {
                    //ログファイルを削除する
                    System.IO.File.Delete(file);
                }
            }
            catch
            {
                return;
            }
        }


        //ログのフォルダを開く
        public void menuItemOpenFolder_Click(object sender, EventArgs e)
        {
            string dir = Const.DataDir + Path.DirectorySeparatorChar + ".ageon"
                + Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "screening"
                + Path.DirectorySeparatorChar + yomi;

            if (System.IO.Directory.Exists(dir) == false)
            {
                System.IO.DirectoryInfo di = new System.IO.DirectoryInfo(dir);
                di.Create();
            }

            System.Diagnostics.Process.Start("EXPLORER.EXE", @"/n, " + dir);

        }

        //全情報を更新する
        public void menuItemUpdate_Click(object sender, EventArgs e)
        {
            MapMainFormConst.getScreeningData.StartScreening();
        }

        //時間設定あり
        public void menuItemTime_Click(object sender, EventArgs e)
        {
            MainFormConst.boardListTabMain.show_board("local://screening/" + yomi, true);
        }
    }
}
