﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

namespace nispi
{
    class MapListTabMain

    {
        public MapControlView worldMapControlView;
        public MapControlView japanMapControlView;

        public static BasicMapData mapData;

        public MapListTabMain()
        {
            mapData = new BasicMapData();

            worldMapControlView = new MapControlView("世界地図  ", "world_front.png", "world_back.png", BasicMapData.kokkaNameDic, BasicMapData.kokkaColorDic, 1600, 800);
            worldMapControlView.tabPageParts.ImageIndex = 1;
            japanMapControlView = new MapControlView("日本地図  ", "japan_front.png", "japan_back.png", BasicMapData.japanNameDic, BasicMapData.japanColorDic, 800, 800);
            japanMapControlView.tabPageParts.ImageIndex = 0;
            Const.mapForm.MapControlTabControlParts.Selected += MapControlTabControlParts_Selecting;

        }

        private void MapControlTabControlParts_Selecting(object sender, TabControlEventArgs e)
        {
            this.worldMapControlView.toolTipParts.HideToolTip();
            this.japanMapControlView.toolTipParts.HideToolTip();
        }
    }
}