﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Drawing;

using nispi.controlclass;

namespace nispi.Menu
{
    class BoardListTabMenu
    {
        public ContextMenuStripParts contextMenuStripParts;

        public ToolStripMenuItemParts menuItemCloseTabParts;
        public ToolStripMenuItemParts menuItemCloseAllTabParts;
        public ToolStripMenuItemParts menuItemAddFavoriteParts;
        public ToolStripMenuItemParts menuItemCreateNewThreadParts;
        public ToolStripMenuItemParts menuItemOpenBrowserParts;
        public ToolStripMenuItemParts menuItemCopyURLParts;
        public ToolStripMenuItemParts menuItemCopyTitleParts;
        public ToolStripMenuItemParts menuItemReloadParts;

        public BoardListTabEvent boardListTabEvent;

        public BoardListTabMenu()
        {
            contextMenuStripParts = ContextMenuStripPartsManager.Pop();

            menuItemCloseTabParts = ToolStripMenuItemPartsManager.Pop();
            menuItemCloseAllTabParts = ToolStripMenuItemPartsManager.Pop();
            menuItemAddFavoriteParts = ToolStripMenuItemPartsManager.Pop();
            menuItemCreateNewThreadParts = ToolStripMenuItemPartsManager.Pop();
            menuItemOpenBrowserParts = ToolStripMenuItemPartsManager.Pop();
            menuItemCopyURLParts = ToolStripMenuItemPartsManager.Pop();
            menuItemCopyTitleParts = ToolStripMenuItemPartsManager.Pop();
            menuItemReloadParts = ToolStripMenuItemPartsManager.Pop();


            menuItemCloseTabParts.Text = "タブを閉じる(&W)(CTRL+W)";
            menuItemCloseAllTabParts.Text = "すべてのタブを閉じる(&Q)(CTRL+Q)";
            menuItemAddFavoriteParts.Text = "お気に入りに追加する(&F)(CTRL+F)";

            menuItemCreateNewThreadParts.Text = "新規スレッド作成(&V)";
            menuItemOpenBrowserParts.Text = "ブラウザーで開く(&B)";

            menuItemCopyURLParts.Text = "URLをコピー(&C)";
            menuItemCopyTitleParts.Text = "板の名前をコピー(&T)";
            menuItemReloadParts.Text = "再読み込み(&R)(CTRL+R)";

            contextMenuStripParts.ItemsAdd(menuItemCloseTabParts);
            contextMenuStripParts.ItemsAdd(menuItemCloseAllTabParts);
            contextMenuStripParts.ItemsAdd("-");
            contextMenuStripParts.ItemsAdd(menuItemAddFavoriteParts);
            contextMenuStripParts.ItemsAdd(menuItemCreateNewThreadParts);
            contextMenuStripParts.ItemsAdd(menuItemOpenBrowserParts);
            contextMenuStripParts.ItemsAdd("-");
            contextMenuStripParts.ItemsAdd(menuItemCopyURLParts);
            contextMenuStripParts.ItemsAdd(menuItemCopyTitleParts);
            contextMenuStripParts.ItemsAdd("-");
            contextMenuStripParts.ItemsAdd(menuItemReloadParts);

            boardListTabEvent = new BoardListTabEvent(this);
        }
    }
}