﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using mshtml;
using System.Windows.Forms;

using nispi;
using nispi.controlclass;

//タブの右下の▼をクリックしたときのメニュー
//開かれているスレッドをメニュー形式で表示
namespace nispi.Menu
{
    class AllThreadMenu
    {
        public ContextMenuStripParts contextMenuStripParts;
        public ToolStripMenuItemParts menuItemThreadParts;
        public ToolStripMenuItemParts menuItemNextParts;

        public List<ToolStripMenuItemParts> threadPartsList;

        public AddressMenuEvent addressEvent;

        public AllThreadMenu()
        {
            contextMenuStripParts = ContextMenuStripPartsManager.Pop();
            threadPartsList = new List<ToolStripMenuItemParts>();
        }

        public void Show(Point point)
        {
            contextMenuStripParts.ClearItem();
            threadPartsList.Clear();

            foreach (ThreadViewCommon threadView in MainFormConst.threadListTabMain.viewList)
            {
                if ((threadView.threadName == null) || (threadView.threadName.Length <= 0))
                    continue;

                threadPartsList.Add(ToolStripMenuItemPartsManager.Pop());
                threadPartsList[threadPartsList.Count - 1].Text = threadView.threadName;
                threadPartsList[threadPartsList.Count - 1].Name = threadView.datUrl;

                //種類によって画像を表示する
                string type = Util.BoardUrlToBoardTypeName(threadView.datUrl);
                Image image = null;

                if (type.Equals("2ch") == true)
                    image = Resources.favicon_2ch;
                else if (type.Equals("2chsc") == true)
                    image = Resources.favicon_sc;
                else if (type.Equals("screening") == true)
                    image = Resources.map;
                else if (type.Equals("open2ch") == true)
                    image = Resources.favicon_open2ch;
                else if (type.Equals("next2ch") == true)
                    image = Resources.favicon_next2ch;

                else if (type.Equals("jikkyo") == true)
                    image = Resources.favicon_jikkyo;
                else if (type.Equals("blogban") == true)
                    image = Resources.favicon_blogban;
                else if (type.Equals("shizu") == true)
                    image = Resources.favicon_shizu;

                else if (type.Equals("vip2ch") == true)
                    image = Resources.favicon_vip2ch;
                else if (type.Equals("machibbs") == true)
                    image = Resources.favicon_machi;
                else if (type.Equals("jbbs") == true)
                    image = Resources.favicon_jbbs;

                threadPartsList[threadPartsList.Count - 1].Image = image;

                contextMenuStripParts.ItemsAdd(threadPartsList[threadPartsList.Count - 1]);
                threadPartsList[threadPartsList.Count - 1].Click += new EventHandler(menuItemThread_Click);
            }
            //表示位置を調節
            point.X -= contextMenuStripParts.Size.Width;
            point.Y -= contextMenuStripParts.Size.Height;
            contextMenuStripParts.Show(Const.form.threadListTabControlParts ,point);
        }

        public void ThreadPartsListClear()
        {
            foreach (ToolStripMenuItemParts parts in threadPartsList)
            {
                parts.Click -= new EventHandler(menuItemThread_Click);
                parts.Image = null;
                parts.Text = null;
                parts.Name = null;
                ToolStripMenuItemPartsManager.Push(parts);
            }
        }

        public bool CheckConsistency()
        {
            return true;
        }

        public void menuItemThread_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            string url = ((ToolStripMenuItem)sender).Name;
            string threadTitle = ((ToolStripMenuItem)sender).Text;
            MainFormConst.ShowThread(url, threadTitle);
        }
    }
}