//CZXAgeOntH_LISENCEtH_QƂĂ
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

using nispi.controlclass;
using nispi.Menu;

namespace nispi
{
    class MainMenuSetup
    {
        //t@C
        public FileMenu fileMenu;

        //CfbNX
        //public BoardIndexTabMainMenu boardIndexTabMainMenu;
        public BoardIndexTreeViewMainMenu boardIndexTreeViewMainMenu;

        //Xg
        public BoardListTabMainMenu boardListTabMainMenu;
        public BoardListViewMainMenu boardListViewMainMenu;

        //XbhXg
        public BrowserNonTextMainMenu nonTextMainMenu;
        public BrowserTextMainMenu textMainMenu;
        public ThreadListTabMainMenu threadListTabMainMenu;

        public AllAnalysisMainMenu allAnalysisMainMenu;

        //c[
        public ToolMenu toolMenu;

        //wv
        public HelpMenu helpMenu;

        public MenuStripParts menuStripParts;

        ToolStripMenuItemParts menuItemFileParts;
        ToolStripMenuItemParts menuItemBoardIndexParts;
        ToolStripMenuItemParts menuItemBoardParts;
        ToolStripMenuItemParts menuItemThreadParts;
        ToolStripMenuItemParts menuItemAnalysisParts;
        ToolStripMenuItemParts menuItemToolParts;
        ToolStripMenuItemParts menuItemHelpParts;

        public ToolStripRenderer toolStripRenderer;

        public MainMenuSetup()
        {
            menuStripParts = MenuStripPartsManager.Pop();
            
            toolStripRenderer = new ToolStripProfessionalRenderer(new MenuColorTable()); ;
            //if (Const.opt.outWardMenu.IsUseRenderer.Equals("True") == true)
            
            menuStripParts.Renderer = toolStripRenderer;

            menuItemFileParts = ToolStripMenuItemPartsManager.Pop();
            menuItemBoardIndexParts = ToolStripMenuItemPartsManager.Pop(); ;
            menuItemBoardParts = ToolStripMenuItemPartsManager.Pop(); ;
            menuItemThreadParts = ToolStripMenuItemPartsManager.Pop(); ;
            menuItemAnalysisParts = ToolStripMenuItemPartsManager.Pop(); ;
            menuItemToolParts = ToolStripMenuItemPartsManager.Pop();
            menuItemHelpParts = ToolStripMenuItemPartsManager.Pop();

            //t@C
            fileMenu = new FileMenu(menuItemFileParts);


            //CfbNX
            //boardIndexTabMainMenu = new BoardIndexTabMainMenu(this.menuItemBoardIndexParts);
            boardIndexTreeViewMainMenu = new BoardIndexTreeViewMainMenu(this.menuItemBoardIndexParts);

            //Xg
            boardListViewMainMenu = new BoardListViewMainMenu(this.menuItemBoardParts);
            boardListTabMainMenu = new BoardListTabMainMenu(this.menuItemBoardParts);


            //XbhXg 
            nonTextMainMenu = new BrowserNonTextMainMenu(this.menuItemThreadParts);
            textMainMenu = new BrowserTextMainMenu(this.menuItemThreadParts);
            threadListTabMainMenu = new ThreadListTabMainMenu(this.menuItemThreadParts);

            //
            allAnalysisMainMenu = new AllAnalysisMainMenu(this.menuItemAnalysisParts);


            //c[
            toolMenu = new ToolMenu(this.menuItemToolParts);

            //wv
            helpMenu = new HelpMenu(this.menuItemHelpParts);


            //o^
            this.menuStripParts.ItemsAdd(menuItemFileParts);
            this.menuStripParts.ItemsAdd(menuItemBoardIndexParts);
            this.menuStripParts.ItemsAdd(menuItemBoardParts);
            this.menuStripParts.ItemsAdd(menuItemThreadParts);
            this.menuStripParts.ItemsAdd(menuItemAnalysisParts);
            this.menuStripParts.ItemsAdd(menuItemToolParts);
            this.menuStripParts.ItemsAdd(menuItemHelpParts);

            this.menuStripParts.Location = new System.Drawing.Point(0, 0);
            this.menuStripParts.Name = "menuStrip";
            //this.menuStrip.TabIndex = 5;
            this.menuStripParts.Text = "menuStrip";

            /*File*/
            this.menuItemFileParts.Name = "menuItemFile";
            this.menuItemFileParts.Text = "t@C(&F)";

            /*BoardIndex*/
            this.menuItemBoardIndexParts.DropDownOpening += new EventHandler(menuItemBoardIndex_DropDownOpening);
            this.menuItemBoardIndexParts.Name = "menuItemBoardIndex";
            this.menuItemBoardIndexParts.Text = "ꗗ(&L)";

            /*Board*/
            this.menuItemBoardParts.DropDownOpening += new EventHandler(menuItemBoard_DropDownOpening);
            this.menuItemBoardParts.Name = "menuItemBoard";
            this.menuItemBoardParts.Text = "Xꗗ(&B)";

            /*Thread*/
            this.menuItemThreadParts.DropDownOpening += new EventHandler(menuItemThread_DropDownOpening);
            this.menuItemThreadParts.Name = "menuItemThread";
            this.menuItemThreadParts.Text = "Xbh(&T)";

            /*Thread*/
            this.menuItemAnalysisParts.DropDownOpening += new EventHandler(menuItemAnalysis_DropDownOpening);
            this.menuItemAnalysisParts.Name = "menuItemAnalysis";
            this.menuItemAnalysisParts.Text = "X(&A)";

            /*menuItemTool*/
            this.menuItemToolParts.Name = "menuItemTool";
            this.menuItemToolParts.Text = "c[(&O)";

            /*menuItemHelp*/
            this.menuItemHelpParts.Name = "menuItemHelp";
            this.menuItemHelpParts.Text = "wv(&H)";

            Const.form.mainForm.AddControl(menuStripParts);
        }

        #region boardindex
        //@j[̒g
        private void menuItemBoardIndex_DropDownOpening(object sender, EventArgs e)
        {
            //boardIndexTabMainMenu.SetMainMenu();
            boardIndexTreeViewMainMenu.SetMainMenu();
        }

        private void menuItemBoardIndex_DropDownClosed(object sender, EventArgs e)
        {
            ;// this.menuItemBoardIndex.DropDownItems.Clear();
        }
        #endregion


        #region board
        // 
        //@j[̒g
        private void menuItemBoard_DropDownOpening(object sender, EventArgs e)
        {
            boardListViewMainMenu.SetMenu();

            boardListTabMainMenu.SetMenu();
        }
        private void menuItemBoard_DropDownClosed(object sender, EventArgs e)
        {
            ;//this.menuItemBoard.DropDownItems.Clear();
        }
        #endregion


        #region thread
        private void menuItemThread_DropDownOpening(object sender, EventArgs e)
        {
            threadListTabMainMenu.SetupMainMenu();

            textMainMenu.SetMainMenu();

            nonTextMainMenu.SetMainMenu();
        }

        #endregion

        #region analysis
        private void menuItemAnalysis_DropDownOpening(object sender, EventArgs e)
        {
            allAnalysisMainMenu.SetMainMenu();
        }
        #endregion
    }
}