﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Runtime.InteropServices;
using System.Drawing;

namespace nispi
{
    class CalendarInThreadView
    {
        private static CalendarCommon calendarCommon = null;
        public static ThreadViewCommon threadView;

        public CalendarInThreadView(ThreadViewCommon _threadView,Point point)
        {
            if (calendarCommon == null)
                calendarCommon = new CalendarCommon(calendar_DateSelected, calendar_LostFocus);

            threadView = _threadView;

            calendarCommon.CalendarShow(point);
        }

        public void calendar_DateSelected(object sender, DateRangeEventArgs e)
        {
            Const.form.mainForm.SetWaitCursor();

            DateTime dt = e.Start.Date;

            string data = dt.Year.ToString().Substring(2, 2) + "年" + dt.Month.ToString() + "月" + dt.Day.ToString() + "日";
            //button.Text = data;

            string month = dt.Month.ToString();
            if (month.Length == 1) month = "0" + month;
            string day = dt.Day.ToString();
            if (day.Length == 1) day = "0" + day;
            string hour = dt.Hour.ToString();
            if (hour.Length == 1) hour = "0" + hour;
            string minute = dt.Minute.ToString();
            if (minute.Length == 1) minute = "0" + minute;
            string second = dt.Second.ToString();
            if (second.Length == 1) second = "0" + second;

            threadView.SetExtractionData(0, dt.Year.ToString() + "/" + month + "/" + day, data);

            Const.form.mainForm.ReSetWaitCursor();

            calendarCommon.popUp.Hide();
            calendarCommon.calendar.Hide();
            threadView.ReShowThread();
        }

        public void calendar_LostFocus(object sender, EventArgs e)
        {
            calendarCommon.popUp.Hide();
            calendarCommon.calendar.Hide();
        }
    }
}