﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;


namespace nispi.controlclass
{
    /// <summary>
    /// ボタンのパーツ。ラッピング。
    /// </summary>
    class PictureBoxParts:ControlBase
    {
        public PictureBox control;

        public PictureBoxParts()
        {
            control = new PictureBox();
            this.controlBase = (System.Windows.Forms.Control)control;
        }

        ///public void AddControl(dynamic parts)
        //{
        //    this.control.Controls.Add(parts.control);
        //}

        public Image Image
        {
            set
            {
                this.control.Image = value;
            }
            get
            {
                return this.control.Image;
            }
        }   

        public void SetDockFill()
        {
            this.control.Dock = DockStyle.Fill;
        }

        /*public void SetAnchor4()
        {
            this.control.Dock = DockStyle.None;

            this.control.Anchor = (AnchorStyles)
                ((AnchorStyles.Top) | (AnchorStyles.Bottom) |
                (AnchorStyles.Left) | (AnchorStyles.Right));
        }*/

        public void ResetControl()
        {
            try
            {
                this.control.Image.Dispose();
                this.control.Image = null;
            }
            catch { ;}//this.control.BorderStyle = BorderStyle.None;
        }
    }

    class PictureBoxPartsManager
    {
        public static Stack<PictureBoxParts> buttonStack = new Stack<PictureBoxParts>();
        public static Mutex mutex = new Mutex(false, "PictureBoxPartsManager");

        public static PictureBoxParts Pop()
        {
            mutex.WaitOne();

            if (buttonStack.Count == 0)
                buttonStack.Push(new PictureBoxParts());

            PictureBoxParts buttonParts = buttonStack.Pop();

            mutex.ReleaseMutex();

            if (buttonParts.Image != null)
            {
                buttonParts.Image.Dispose();
                buttonParts.Image = null;
            }
            return buttonParts;
        }

        public static void Push(PictureBoxParts buttonParts)
        {
            buttonParts.ResetControlBase();
            buttonParts.ResetControl();

            mutex.WaitOne();

            buttonStack.Push(buttonParts);

            mutex.ReleaseMutex();
        }
    }
}